/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CallingThreadExecutorService
extends AbstractExecutorService
implements ExecutorService {
    private final Lock _lock = new ReentrantLock();
    private final Condition _terminatedCondition = this._lock.newCondition();
    private boolean _shutdownRequested = false;
    private boolean _terminated = false;
    private final Map<Thread, Runnable> _currentThreads = new ConcurrentHashMap<Thread, Runnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this._lock.lock();
        try {
            if (this.isTerminated()) {
                boolean bl = true;
                return bl;
            }
            if (this.isShutdown() && this._currentThreads.isEmpty()) {
                this._terminated = true;
                this._terminatedCondition.signalAll();
                boolean bl = true;
                return bl;
            }
            boolean bl = this._terminatedCondition.await(timeout, unit);
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        this._lock.lock();
        try {
            if (this.isShutdown()) {
                throw new IllegalStateException("Executor is shut down");
            }
            this._currentThreads.put(Thread.currentThread(), command);
        }
        finally {
            this._lock.unlock();
        }
        try {
            command.run();
        }
        finally {
            this._lock.lock();
            try {
                this._currentThreads.remove(Thread.currentThread());
                if (this.isShutdown() && this._currentThreads.isEmpty()) {
                    this._terminated = true;
                    this._terminatedCondition.signalAll();
                }
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        this._lock.lock();
        try {
            boolean bl = this._shutdownRequested;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        this._lock.lock();
        try {
            boolean bl = this._terminated;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this._lock.lock();
        try {
            this._shutdownRequested = true;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this._lock.lock();
        try {
            this._shutdownRequested = true;
            for (Thread t : this._currentThreads.keySet()) {
                t.interrupt();
            }
            this._terminated = true;
            this._terminatedCondition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
        return new LinkedList<Runnable>();
    }
}

