/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CancellableCompletionService<V>
extends ExecutorCompletionService<V> {
    private final Set<Future<V>> _currentTasks = Collections.synchronizedSet(new HashSet());

    public CancellableCompletionService(Executor executor) {
        super(executor);
    }

    public CancellableCompletionService(Executor executor, BlockingQueue<Future<V>> completionQueue) {
        super(executor, completionQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Set<Future<V>> set = this._currentTasks;
        synchronized (set) {
            Iterator<Future<V>> tasks = this._currentTasks.iterator();
            while (tasks.hasNext()) {
                Future<V> task = tasks.next();
                task.cancel(true);
                tasks.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> poll() {
        Future f = super.poll();
        if (f != null) {
            Set<Future<V>> set = this._currentTasks;
            synchronized (set) {
                this._currentTasks.remove(f);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Future f = super.poll(timeout, unit);
        if (f != null) {
            Set<Future<V>> set = this._currentTasks;
            synchronized (set) {
                this._currentTasks.remove(f);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> submit(Callable<V> task) {
        Future<V> f = super.submit(task);
        Set<Future<V>> set = this._currentTasks;
        synchronized (set) {
            this._currentTasks.add(f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> submit(Runnable task, V result) {
        Future<V> f = super.submit(task, result);
        Set<Future<V>> set = this._currentTasks;
        synchronized (set) {
            this._currentTasks.add(f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> take() throws InterruptedException {
        Future f = super.take();
        Set<Future<V>> set = this._currentTasks;
        synchronized (set) {
            this._currentTasks.remove(f);
        }
        return f;
    }
}

