/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TaskTimer {
    private final NanoTime _nanoTime = new NanoTime();
    private final String _taskName;
    private final Long _timeout;
    private final TimeUnit _unit;
    private final Long _startTimeNanos = this.currentTimeNanos();
    private Long _completedTimeNanos = null;
    private final List<TaskTimer> _subtasks = new LinkedList<TaskTimer>();

    public TaskTimer() {
        this(Thread.currentThread().getName() + "-TaskTimer", Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public TaskTimer(Long timeout) {
        this(Thread.currentThread().getName() + "-TaskTimer", timeout, TimeUnit.MILLISECONDS);
    }

    public TaskTimer(Long timeout, TimeUnit unit) {
        this(Thread.currentThread().getName() + "-TaskTimer", timeout, unit);
    }

    public TaskTimer(String taskName, Long timeoutMillis) {
        this(taskName, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public TaskTimer(String taskName, Long timeout, TimeUnit unit) {
        this._timeout = timeout;
        this._taskName = taskName;
        this._unit = unit;
    }

    public TaskTimer(TaskTimer timer) {
        this(timer.getTaskName(), timer.getTimeout(), timer.getTimeUnit());
    }

    public final Long checkTimeout() throws TimeoutException {
        if (this.isCompleted()) {
            return Long.MIN_VALUE;
        }
        Long remaining = this.remaining();
        if (remaining <= 0L) {
            throw new TimeoutException(this.formatTimeoutMessage());
        }
        return remaining;
    }

    public final TaskTimer createSubTaskTimer(String name) throws TimeoutException {
        Long remainingNanos = this.checkTimeout();
        TaskTimer subTaskTimer = new TaskTimer(name, this.isEnabled() ? remainingNanos : 0L, TimeUnit.NANOSECONDS);
        this._subtasks.add(subTaskTimer);
        return subTaskTimer;
    }

    public final long currentTimeNanos() {
        return this._nanoTime.currentTimeNanos();
    }

    public Long elapsed() {
        if (this.isCompleted()) {
            return this.getCompletedTimeNanos() - this.getStartTimeNanos();
        }
        return this.currentTimeNanos() - this.getStartTimeNanos();
    }

    public final Long getCompletedTimeNanos() {
        return this._completedTimeNanos;
    }

    public final Long getStartTimeNanos() {
        return this._startTimeNanos;
    }

    public final List<TaskTimer> getSubTaskTimers() {
        return Collections.unmodifiableList(this._subtasks);
    }

    public final String getTaskName() {
        return this._taskName;
    }

    public final Long getTimeout() {
        return this._timeout;
    }

    public final Long getTimeoutNanos() {
        return this.getTimeUnit().toNanos(this.getTimeout());
    }

    public final TimeUnit getTimeUnit() {
        return this._unit;
    }

    public <V> List<Future<V>> invokeAll(ExecutorService executor, Collection<? extends Callable<V>> tasks) throws InterruptedException, TimeoutException {
        Long remaining = this.checkTimeout();
        if (!this.isEnabled()) {
            return executor.invokeAll(tasks);
        }
        return executor.invokeAll(tasks, remaining, TimeUnit.NANOSECONDS);
    }

    public final boolean isCompleted() {
        return this._completedTimeNanos != null;
    }

    public final boolean isEnabled() {
        return this._timeout != null && this._timeout > 0L;
    }

    public final boolean isExpired() {
        return !this.isCompleted() && this.isEnabled() && this.remaining() <= 0L;
    }

    public <V> void offer(BlockingQueue<V> queue, V value) throws InterruptedException, TimeoutException {
        Long remaining = this.checkTimeout();
        if (!this.isEnabled()) {
            queue.put(value);
        } else if (!queue.offer(value, remaining, TimeUnit.NANOSECONDS)) {
            throw new TimeoutException(this.formatTimeoutMessage());
        }
    }

    public <V> V poll(CompletionService<V> completionService) throws TimeoutException, ExecutionException, InterruptedException {
        Future<V> f = this.pollFuture(completionService);
        return f == null ? null : (V)f.get();
    }

    public <V> V poll(Future<V> future) throws TimeoutException, ExecutionException, InterruptedException {
        if (future.isDone()) {
            return future.get();
        }
        Long remaining = this.checkTimeout();
        if (!this.isEnabled()) {
            return future.get();
        }
        if (remaining > 0L) {
            return future.get(remaining, TimeUnit.NANOSECONDS);
        }
        throw new TimeoutException(this.formatTimeoutMessage());
    }

    public <V> Future<V> pollFuture(CompletionService<V> completionService) throws TimeoutException, InterruptedException {
        Future<V> f = null;
        Long remaining = this.checkTimeout();
        if (!this.isEnabled()) {
            f = completionService.take();
        } else if (remaining > 0L) {
            f = completionService.poll(remaining, TimeUnit.NANOSECONDS);
            if (f == null) {
                throw new TimeoutException(this.formatTimeoutMessage() + " in completion service.");
            }
        } else {
            throw new TimeoutException(this.formatTimeoutMessage());
        }
        return f;
    }

    private String formatTimeoutMessage() {
        return String.format("Task %s timeout (%d %s) has expired.", new Object[]{this.getTaskName(), this.getTimeUnit().toMillis(this.getTimeout()), TimeUnit.MILLISECONDS});
    }

    public final Long remaining() {
        if (this.isCompleted()) {
            return Long.MIN_VALUE;
        }
        return !this.isEnabled() ? Long.MAX_VALUE : this.getTimeoutNanos() - this.elapsed();
    }

    public final void stop() {
        if (this._completedTimeNanos != null) {
            return;
        }
        this._completedTimeNanos = this.currentTimeNanos();
    }

    public String toString() {
        return String.format("%s[timeout=%d %s]", new Object[]{this.getTaskName(), this.getTimeout(), this.getTimeUnit()});
    }

    public static final class NanoTime {
        private final long NANO_TIME = System.nanoTime();

        public long currentTimeNanos() {
            return System.nanoTime() - this.NANO_TIME;
        }
    }
}

