/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ThreadFactories {
    public static final ThreadFactory createThreadFactory(String namePrefix) {
        return new NamedThreadFactory(null, namePrefix, false);
    }

    public static final ThreadFactory createThreadFactory(ThreadGroup group, String namePrefix) {
        return new NamedThreadFactory(group, namePrefix, false);
    }

    public static final ThreadFactory createThreadFactory(ThreadGroup group, String namePrefix, boolean daemon) {
        return new NamedThreadFactory(group, namePrefix, daemon);
    }

    private ThreadFactories() {
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final String namePrefix;
        private final boolean daemon;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public NamedThreadFactory(ThreadGroup group, String namePrefix, boolean daemon) {
            this.group = group;
            this.namePrefix = namePrefix;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.format("%s-%s", this.namePrefix, this.threadNumber.getAndIncrement()), 0L);
            t.setDaemon(this.daemon);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            t.setUncaughtExceptionHandler(DefaultUncaughtExceptionHandler.getInstance());
            return t;
        }
    }

    static enum DefaultUncaughtExceptionHandler implements Thread.UncaughtExceptionHandler
    {
        INSTANCE;


        public static final DefaultUncaughtExceptionHandler getInstance() {
            return INSTANCE;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Logger logger = Logger.getRootLogger();
            logger.error((Object)String.format("Thread %s terminated with uncaught exception %s", t, e.getMessage()), e);
        }
    }
}

