/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent;

import com.sybase.ua.util.concurrent.TaskTimer;
import com.sybase.ua.util.concurrent.TimedTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimedFutureTask<V>
extends FutureTask<V> {
    private final TaskTimer _timer;

    public TimedFutureTask(Callable<V> command, TaskTimer timer) {
        super(command);
        this._timer = timer;
    }

    public TimedFutureTask(TimedTask<V> command) {
        super(command);
        this._timer = command.getTimer();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            if (this.isDone()) {
                return super.get();
            }
            long timerRemaining = this._timer.checkTimeout();
            if (timerRemaining == Long.MIN_VALUE) {
                return super.get();
            }
            return super.get(timerRemaining, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException te) {
            this.cancel(true);
            throw new ExecutionException("Task timed out", te);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            if (this.isDone()) {
                return super.get(timeout, unit);
            }
            long timerRemaining = this._timer.checkTimeout();
            if (timerRemaining == Long.MIN_VALUE) {
                return super.get(timeout, unit);
            }
            long timeoutNanos = Math.min(unit.toNanos(timeout), this._timer.getTimeUnit().toNanos(timerRemaining));
            return super.get(timeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException te) {
            if (this._timer.isExpired()) {
                super.cancel(true);
            }
            throw te;
        }
    }

    public TaskTimer getTimer() {
        return this._timer;
    }

    public boolean isExpired() {
        return this._timer.isExpired();
    }

    @Override
    protected void done() {
        this._timer.stop();
        super.done();
    }
}

