/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent;

import com.sybase.ua.util.concurrent.TaskTimer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Timeout {
    private Long _timeout = 0L;
    private TimeUnit _timeoutUnits = TimeUnit.MILLISECONDS;

    public static Timeout createNoTimeoutPolicy() {
        return new Timeout(0L);
    }

    public static Timeout createTimeout(Long timeoutMillis) {
        return new Timeout(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public static Timeout createTimeout(Long timeout, TimeUnit units) {
        return new Timeout(timeout, units);
    }

    public Timeout(Long timeoutMillis) {
        this(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public Timeout(Long timeout, TimeUnit units) {
        this._timeout = timeout;
        this._timeoutUnits = units;
    }

    protected Timeout() {
    }

    public Long getTimeout() {
        return this._timeout;
    }

    public TimeUnit getTimeoutUnits() {
        return this._timeoutUnits;
    }

    public <V> List<Future<V>> invokeAll(ExecutorService executor, Collection<? extends Callable<V>> tasks) throws InterruptedException {
        if (this._timeout > 0L) {
            return executor.invokeAll(tasks, this._timeout, this._timeoutUnits);
        }
        return executor.invokeAll(tasks);
    }

    public <V> V poll(CompletionService<V> completionService) throws TimeoutException, ExecutionException, InterruptedException {
        Future<V> f = this.pollFuture(completionService);
        return f == null ? null : (V)f.get();
    }

    public <V> V poll(Future<V> future) throws TimeoutException, ExecutionException, InterruptedException {
        if (this._timeout > 0L) {
            return future.get(this._timeout, this._timeoutUnits);
        }
        return future.get();
    }

    public <V> Future<V> pollFuture(CompletionService<V> completionService) throws TimeoutException, ExecutionException, InterruptedException {
        Future<V> f = null;
        if (this._timeout > 0L) {
            f = completionService.poll(this._timeout, this._timeoutUnits);
            if (f == null) {
                throw new TimeoutException("Collection completion Service polling timed out");
            }
        } else if (this._timeout == 0L) {
            f = completionService.take();
        }
        return f;
    }

    public TaskTimer startTaskTimer() {
        return new TaskTimer(this.getTimeout(), this.getTimeoutUnits());
    }

    public TaskTimer startTaskTimer(String name) {
        return new TaskTimer(name, this.getTimeout(), this.getTimeoutUnits());
    }

    public Long timeoutMillis() {
        return this._timeoutUnits.toMillis(this._timeout);
    }

    public Long timeoutMinutes() {
        return this._timeoutUnits.toMinutes(this._timeout);
    }

    public Long timeoutNanos() {
        return this._timeoutUnits.toNanos(this._timeout);
    }

    public Long timeoutSeconds() {
        return this._timeoutUnits.toSeconds(this._timeout);
    }

    public String toString() {
        return String.format("%s %s", this._timeout, this._timeoutUnits.name().toLowerCase());
    }

    protected void setTimeout(Long timeout, TimeUnit units) {
        this._timeout = timeout;
        this._timeoutUnits = units;
    }
}

