/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ProcessCpuTimer {
    public static boolean isProcessCpuTimeSupported() {
        return ProcessCpuTimer.getProcessCpuTimer().isProcessCpuTimeSupported();
    }

    public static long getProcessCpuTime() {
        return ProcessCpuTimer.getProcessCpuTimer().getProcessCpuTime();
    }

    public static IProcessCpuTimer getProcessCpuTimer() {
        if (SunProcessCpuTimer.INSTANCE.isProcessCpuTimeSupported()) {
            return SunProcessCpuTimer.INSTANCE;
        }
        return NullProcessCpuTimer.INSTANCE;
    }

    public static enum SunProcessCpuTimer implements IProcessCpuTimer
    {
        INSTANCE;

        private static final OperatingSystemMXBean _operatingSystemMXBean;
        private static final Method _getProcessCpuTimeMethod;
        private static final Object[] NO_ARGS;

        @Override
        public boolean isProcessCpuTimeSupported() {
            return _getProcessCpuTimeMethod != null;
        }

        @Override
        public long getProcessCpuTime() {
            try {
                if (!this.isProcessCpuTimeSupported()) {
                    return -1L;
                }
                return (Long)_getProcessCpuTimeMethod.invoke((Object)_operatingSystemMXBean, NO_ARGS);
            }
            catch (IllegalAccessException e) {
                return -1L;
            }
            catch (InvocationTargetException e) {
                return -1L;
            }
        }

        static Method getProcessCpuTimeMethod() {
            if (_operatingSystemMXBean == null) {
                return null;
            }
            try {
                Method getProcessCpuTimeMethod = _operatingSystemMXBean.getClass().getMethod("getProcessCpuTime", null);
                return getProcessCpuTimeMethod;
            }
            catch (SecurityException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        static {
            _operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            _getProcessCpuTimeMethod = SunProcessCpuTimer.getProcessCpuTimeMethod();
            NO_ARGS = new Object[0];
        }
    }

    public static enum NullProcessCpuTimer implements IProcessCpuTimer
    {
        INSTANCE;


        @Override
        public long getProcessCpuTime() {
            return -1L;
        }

        @Override
        public boolean isProcessCpuTimeSupported() {
            return false;
        }
    }

    public static interface IProcessCpuTimer {
        public boolean isProcessCpuTimeSupported();

        public long getProcessCpuTime();
    }
}

