/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import com.sybase.ua.util.concurrent.monitor.ThreadIdFilter;
import com.sybase.ua.util.concurrent.monitor.ThreadInfoFilter;
import com.sybase.ua.util.concurrent.monitor.ThreadMonitor;
import java.io.Serializable;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.management.MXBean;

@MXBean
public class ThreadDump
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ThreadInfoFilter> _detailedThreadInfoInclusionFilters = new LinkedList<ThreadInfoFilter>();
    private final long _timestamp = System.currentTimeMillis();
    private final Date _timestampAsDate = new Date(this._timestamp);
    private final long _live = ThreadMonitor._threadMXBean.getThreadCount();
    private final long _daemon = ThreadMonitor._threadMXBean.getDaemonThreadCount();
    private final long _peak = ThreadMonitor._threadMXBean.getPeakThreadCount();
    private final long _totalStarted = ThreadMonitor._threadMXBean.getTotalStartedThreadCount();
    private final boolean _cpuTimeEnabed = ThreadMonitor._threadMXBean.isThreadCpuTimeSupported() && ThreadMonitor._threadMXBean.isThreadCpuTimeEnabled();
    private final boolean _contentionMonitoringEnabled = ThreadMonitor._threadMXBean.isThreadContentionMonitoringSupported() && ThreadMonitor._threadMXBean.isThreadContentionMonitoringEnabled();
    private final boolean _monitorUsageMonitoringEnabled = ThreadMonitor._threadMXBean.isObjectMonitorUsageSupported();
    private final boolean _synchronizerUsageMonitoringEnabled = ThreadMonitor._threadMXBean.isSynchronizerUsageSupported();
    private final ThreadInfo[] _activeThreads;
    private final ThreadInfo[] _deadlockedThreads;
    private final ThreadInfo[] _monitorDeadlockedThreads;
    private final ThreadInfo[] _monitoredThreadDetails;

    public ThreadDump() {
        this((List<ThreadInfoFilter>)null);
    }

    public ThreadDump(boolean allDetailed) {
        this(allDetailed ? new ThreadIdFilter(ThreadMonitor._threadMXBean.getAllThreadIds()) : (ThreadInfoFilter)null);
    }

    public ThreadDump(long ... detailed) {
        this(new ThreadIdFilter(detailed));
    }

    public ThreadDump(ThreadInfoFilter ... filters) {
        this(filters != null ? Arrays.asList(filters) : (List)null);
    }

    public ThreadDump(List<ThreadInfoFilter> inclusionFilters) {
        if (inclusionFilters != null) {
            this._detailedThreadInfoInclusionFilters.addAll(inclusionFilters);
        }
        long[] activeThreadIds = ThreadMonitor._threadMXBean.getAllThreadIds();
        long[] deadlocked = ThreadMonitor._threadMXBean.isThreadContentionMonitoringSupported() && ThreadMonitor._threadMXBean.isThreadContentionMonitoringEnabled() ? ThreadMonitor._threadMXBean.findDeadlockedThreads() : new long[]{};
        long[] monDeadlocked = ThreadMonitor._threadMXBean.isThreadContentionMonitoringSupported() && ThreadMonitor._threadMXBean.isThreadContentionMonitoringEnabled() ? ThreadMonitor._threadMXBean.findMonitorDeadlockedThreads() : new long[]{};
        this._activeThreads = ThreadMonitor._threadMXBean.getThreadInfo(activeThreadIds);
        this._deadlockedThreads = ThreadDump.getDetailedThreadInfo(deadlocked);
        this._monitorDeadlockedThreads = ThreadDump.getDetailedThreadInfo(monDeadlocked);
        long[] filteredThreadIdList = ThreadMonitor.applyThreadInfoFilters(this._detailedThreadInfoInclusionFilters, this._activeThreads);
        this._monitoredThreadDetails = ThreadDump.getDetailedThreadInfo(filteredThreadIdList);
    }

    private static ThreadInfo[] getDetailedThreadInfo(long ... ids) {
        if (ids == null || ids.length <= 0) {
            return null;
        }
        return ThreadMonitor._threadMXBean.getThreadInfo(ids, ThreadMonitor._threadMXBean.isObjectMonitorUsageSupported(), ThreadMonitor._threadMXBean.isSynchronizerUsageSupported());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadDump other = (ThreadDump)obj;
        return this._timestamp == other._timestamp;
    }

    public ThreadInfo[] getActiveThreads() {
        return this._activeThreads;
    }

    public long getDaemon() {
        return this._daemon;
    }

    public ThreadInfo[] getDeadlockedThreads() {
        return this._deadlockedThreads;
    }

    public List<ThreadInfoFilter> getDetailedThreadInfoInclusionFilters() {
        return Collections.unmodifiableList(this._detailedThreadInfoInclusionFilters);
    }

    public long getLive() {
        return this._live;
    }

    public ThreadInfo[] getMonitorDeadlockedThreads() {
        return this._monitorDeadlockedThreads;
    }

    public ThreadInfo[] getMonitoredThreadDetails() {
        return this._monitoredThreadDetails;
    }

    public long getPeak() {
        return this._peak;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public Date getTimestampAsDate() {
        return this._timestampAsDate;
    }

    public long getTotalStarted() {
        return this._totalStarted;
    }

    public boolean hasDeadlockedThreads() {
        return this.getDeadlockedThreadCount() > 0;
    }

    public int getDeadlockedThreadCount() {
        int dl = this._deadlockedThreads != null ? this._deadlockedThreads.length : 0;
        int mdl = this._monitorDeadlockedThreads != null ? this._monitorDeadlockedThreads.length : 0;
        return dl + mdl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this._timestamp ^ this._timestamp >>> 32);
        return result;
    }

    public boolean isContentionMonitoringEnabled() {
        return this._contentionMonitoringEnabled;
    }

    public boolean isCpuTimeEnabed() {
        return this._cpuTimeEnabed;
    }

    public boolean isMonitorUsageMonitoringEnabled() {
        return this._monitorUsageMonitoringEnabled;
    }

    public boolean isSynchronizerUsageMonitoringEnabled() {
        return this._synchronizerUsageMonitoringEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("<ThreadDump timestamp=\"%s\", totalStarted=\"%s\", live=\"%s\", daemon=\"%s\", peak=\"%s\" >\n", this._timestamp, this._totalStarted, this._live, this._daemon, this._peak));
        sb.append("Active=").append(Arrays.toString(this._activeThreads)).append("\n").append("SynchronizerDeadlocked=").append(Arrays.toString(this._deadlockedThreads)).append("\n").append("MonitorDeadlocked=").append(Arrays.toString(this._monitorDeadlockedThreads)).append("\n").append("MonitoredThreadDetails=").append(Arrays.toString(this._monitoredThreadDetails)).append("\n");
        sb.append("</ThreadDump>");
        return sb.toString();
    }
}

