/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import com.sybase.ua.util.concurrent.monitor.ThreadDump;
import com.sybase.ua.util.concurrent.monitor.ThreadDumpWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ThreadDumpSimpleWriter
implements ThreadDumpWriter {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final SimpleDateFormat DATE_FORMAT_MILLIS = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
    public static final String LINE_HEADER_FORMAT = "ThreadDump[%s]";
    public static final String ACTIVE_THREAD_HEADER_FORMAT = "ThreadDump[%s]-Active";
    public static final String MON_DEADLOCK_THREAD_HEADER_FORMAT = "ThreadDump[%s]-MonitorDeadlocked";
    public static final String SYNC_DEADLOCK_THREAD_HEADER_FORMAT = "ThreadDump[%s]-SynchronizerDeadlocked";
    public static final String MONITORED_THREAD_DETAILS_HEADER_FORMAT = "ThreadDump[%s]-MonitoredThreadDetails";
    private final PrintWriter _writer;
    private final boolean _detailedThreadsOnly;

    public ThreadDumpSimpleWriter() throws IOException {
        this(new PrintWriter(System.out));
    }

    public ThreadDumpSimpleWriter(boolean detailed) throws IOException {
        this(new PrintWriter(System.out), detailed);
    }

    public ThreadDumpSimpleWriter(File f) throws IOException, FileNotFoundException {
        this(new PrintWriter(f));
    }

    public ThreadDumpSimpleWriter(File f, boolean detailed) throws IOException, FileNotFoundException {
        this(new PrintWriter(f), detailed);
    }

    public ThreadDumpSimpleWriter(Writer w) throws IOException {
        this(w, true);
    }

    public ThreadDumpSimpleWriter(Writer w, boolean detailedOnly) throws IOException {
        this._writer = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
        this._detailedThreadsOnly = detailedOnly;
    }

    @Override
    public void close() throws IOException {
        this._writer.close();
    }

    @Override
    public void flush() throws IOException {
        this._writer.flush();
    }

    @Override
    public void write(ThreadDump sample) {
        ThreadDumpSimpleWriter.write(this._writer, sample, this._detailedThreadsOnly);
    }

    public static void write(PrintWriter writer, ThreadDump sample, boolean detailedThreadsOnly) {
        ThreadInfo[] monitoredThreadDetails;
        String ts = DATE_FORMAT_MILLIS.format(new Date(sample.getTimestamp()));
        writer.format("ThreadDump[%s]: totalStarted=%s, live=%s, daemon=%s, peak=%s, deadlocked=%s\n", ts, sample.getTotalStarted(), sample.getLive(), sample.getDaemon(), sample.getPeak(), sample.getDeadlockedThreadCount());
        if (!detailedThreadsOnly) {
            writer.format("ThreadDump[%s]-Active: count=%s\n", ts, sample.getLive());
            ThreadDumpSimpleWriter.write(writer, String.format(ACTIVE_THREAD_HEADER_FORMAT, ts), sample.getActiveThreads());
        }
        if (sample.hasDeadlockedThreads()) {
            ThreadInfo[] syncDeadlocks = sample.getDeadlockedThreads();
            ThreadInfo[] monDeadlocks = sample.getMonitorDeadlockedThreads();
            if (syncDeadlocks != null && syncDeadlocks.length > 0) {
                writer.format("ThreadDump[%s]-SynchronizerDeadlocked: count=%s\n", ts, syncDeadlocks.length);
                ThreadDumpSimpleWriter.write(writer, String.format(SYNC_DEADLOCK_THREAD_HEADER_FORMAT, ts), syncDeadlocks);
            }
            if (monDeadlocks != null && monDeadlocks.length > 0) {
                writer.format("ThreadDump[%s]-MonitorDeadlocked: count=%s\n", ts, monDeadlocks.length);
                ThreadDumpSimpleWriter.write(writer, String.format(MON_DEADLOCK_THREAD_HEADER_FORMAT, ts), monDeadlocks);
            }
        }
        if ((monitoredThreadDetails = sample.getMonitoredThreadDetails()) != null && monitoredThreadDetails.length > 0) {
            ThreadDumpSimpleWriter.write(writer, String.format(MONITORED_THREAD_DETAILS_HEADER_FORMAT, ts), monitoredThreadDetails);
        }
        writer.flush();
    }

    protected void write(String header, ThreadInfo thread) {
        ThreadDumpSimpleWriter.write(this._writer, header, thread);
    }

    public static void write(PrintWriter writer, String header, ThreadInfo thread) {
        String headerId = String.format(header + "Thread[%s]", thread.getThreadId());
        writer.format("%s: threadName=%s, threadState=%s, blockedCount=%s, blockedTime=%s, waitedCount=%s, waitedTime=%s, inNative=%s, suspended=%s\n", new Object[]{headerId, thread.getThreadName(), thread.getThreadState(), thread.getBlockedCount(), thread.getBlockedTime(), thread.getWaitedCount(), thread.getWaitedTime(), thread.isInNative(), thread.isSuspended()});
        if (thread.getLockInfo() != null) {
            writer.format("%s: lockInfo: className=%s, identityHashCode=%s, lockName=%s, lockOwnerName=%s, lockOwnerId=%s\n", headerId, thread.getLockInfo().getClassName(), thread.getLockInfo().getIdentityHashCode(), thread.getLockName(), thread.getLockOwnerName(), thread.getLockOwnerId());
        } else {
            writer.format("%s: lockInfo: none\n", headerId);
        }
        MonitorInfo[] monitors = thread.getLockedMonitors();
        if (monitors != null && monitors.length > 0) {
            for (MonitorInfo mi : monitors) {
                int stackDepth = mi.getLockedStackDepth();
                StackTraceElement stackFrame = mi.getLockedStackFrame();
                if (stackFrame == null) {
                    writer.format("%s: monitor: id=%s, lockedStackDepth=%s\n", headerId, mi.toString(), stackDepth);
                    continue;
                }
                writer.format("%s: monitor: lockedStackDepth=%s, lockedStackFrame=%s\n", headerId, stackDepth, stackFrame);
            }
        } else {
            writer.format("%s: monitor: none\n", headerId);
        }
        LockInfo[] synchronizers = thread.getLockedSynchronizers();
        if (synchronizers != null && synchronizers.length > 0) {
            for (LockInfo li : synchronizers) {
                writer.format("%s: synchronizer: className=%s, identityHashCode=%s\n", headerId, li.getClassName(), li.getIdentityHashCode());
            }
        } else {
            writer.format("%s: synchronizer: none\n", headerId);
        }
        StackTraceElement[] stackTrace = thread.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            int frame = 1;
            for (StackTraceElement st : stackTrace) {
                writer.format("%s: stack[%d]: %-8s\n", headerId, frame++, st.toString());
            }
        }
    }

    protected void write(String header, ThreadInfo[] threads) {
        ThreadDumpSimpleWriter.write(this._writer, header, threads);
    }

    public static void write(PrintWriter writer, String header, ThreadInfo[] threads) {
        for (ThreadInfo t : threads) {
            ThreadDumpSimpleWriter.write(writer, header, t);
        }
    }
}

