/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import com.sybase.ua.util.concurrent.monitor.ThreadDump;
import com.sybase.ua.util.concurrent.monitor.ThreadDumpWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;

public class ThreadDumpXMLWriter
implements ThreadDumpWriter {
    private final PrintWriter _writer;

    public ThreadDumpXMLWriter() {
        this._writer = new PrintWriter(System.out);
    }

    public ThreadDumpXMLWriter(File f) throws IOException {
        this._writer = new PrintWriter(f);
    }

    public ThreadDumpXMLWriter(Writer w) throws IOException {
        this._writer = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
    }

    @Override
    public void close() throws IOException {
        this._writer.close();
    }

    @Override
    public void flush() throws IOException {
        this._writer.flush();
    }

    @Override
    public void write(ThreadDump sample) {
        ThreadInfo[] monitoredThreadDetails;
        this._writer.format("<ThreadDump timestamp=\"%s\", totalStarted=\"%s\", live=\"%s\", daemon=\"%s\", peak=\"%s\" >\n", sample.getTimestamp(), sample.getTotalStarted(), sample.getLive(), sample.getDaemon(), sample.getPeak());
        this._writer.format("<active count=\"%s\">\n", sample.getLive());
        this.write(sample.getActiveThreads());
        this._writer.append("</active>\n");
        ThreadInfo[] syncDeadlocks = sample.getDeadlockedThreads();
        ThreadInfo[] monDeadLocks = sample.getMonitorDeadlockedThreads();
        boolean addedDeadlockElem = false;
        if (syncDeadlocks != null && syncDeadlocks.length > 0) {
            this._writer.append("<deadlocks>\n");
            addedDeadlockElem = true;
            this._writer.append("\t<synchronizerDeadlocked>\n");
            this.write(sample.getDeadlockedThreads());
            this._writer.append("\t</synchronizerDeadlocked>\n");
        }
        if (monDeadLocks != null && monDeadLocks.length > 0) {
            if (!addedDeadlockElem) {
                this._writer.append("<deadlocks>\n");
                addedDeadlockElem = true;
            }
            this._writer.append("\t<monitorDeadlocked>\n");
            this.write(sample.getMonitorDeadlockedThreads());
            this._writer.append("\t</monitorDeadlocked>\n");
        }
        if (addedDeadlockElem) {
            this._writer.append("</deadlocks>\n");
        }
        if ((monitoredThreadDetails = sample.getMonitoredThreadDetails()) != null && monitoredThreadDetails.length > 0) {
            this._writer.append("\t<MonitoredThreads>\n");
            this.write(monitoredThreadDetails);
            this._writer.append("\t</MonitoredThreads>\n");
        }
        this._writer.append("</ThreadDump>\n");
        this._writer.flush();
    }

    protected void write(ThreadInfo thread) {
        this._writer.format("<thread id=\"%s\" name=\"%s\" state=\"%s\" blockedCount=\"%s\" blockedTime=\"%s\" waitedCount=\"%s\" waitedTime=\"%s\" native=\"%s\" suspended=\"%s\" >\n", new Object[]{thread.getThreadId(), thread.getThreadName(), thread.getThreadState(), thread.getBlockedCount(), thread.getBlockedTime(), thread.getWaitedCount(), thread.getWaitedTime(), thread.isInNative(), thread.isSuspended()});
        if (thread.getLockInfo() != null) {
            this._writer.format("\t<lockInfo id=\"%s\" lockName=\"%s\" lockOwnerName=\"%s\" lockOwnerId=\"%s\" />\n", thread.getLockInfo().toString(), thread.getLockName(), thread.getLockOwnerName(), thread.getLockOwnerId());
        }
        MonitorInfo[] monitors = thread.getLockedMonitors();
        this._writer.format("\t<monitors>\n", new Object[0]);
        if (monitors != null && monitors.length > 0) {
            for (MonitorInfo mi : monitors) {
                int stackDepth = mi.getLockedStackDepth();
                StackTraceElement stackFrame = mi.getLockedStackFrame();
                if (stackFrame == null) {
                    this._writer.format("\t\t<monitor id=\"%s\" />\n", mi.toString());
                    continue;
                }
                this._writer.format("\t\t<monitor id=\"%s\" lockedStackDepth=\"%s\" lockedStackFrame=\"%s\" />\n", mi.toString(), stackDepth, stackFrame);
            }
        }
        this._writer.format("\t</monitors>\n", new Object[0]);
        LockInfo[] synchronizers = thread.getLockedSynchronizers();
        this._writer.format("\t<synchronizers>\n", new Object[0]);
        if (synchronizers != null && synchronizers.length > 0) {
            for (LockInfo li : synchronizers) {
                this._writer.format("\t\t<synchronizor id=\"%s\" />\n", li.toString());
            }
        }
        this._writer.format("\t</synchronizers>\n", new Object[0]);
        StackTraceElement[] stackTrace = thread.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            this._writer.format("\t<stackTrace>\n", new Object[0]);
            for (StackTraceElement st : stackTrace) {
                this._writer.format("%-8s\n", st.toString());
            }
            this._writer.format("\t</stackTrace>\n", new Object[0]);
        }
        this._writer.format("</thread>\n", new Object[0]);
    }

    protected void write(ThreadInfo[] threads) {
        for (ThreadInfo t : threads) {
            this.write(t);
        }
    }
}

