/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import com.sybase.ua.util.concurrent.monitor.ThreadInfoFilter;
import java.lang.management.ThreadInfo;

public class ThreadGroupFilter
implements ThreadInfoFilter {
    private final ThreadGroup _threadGroup;
    private boolean _recurse = false;

    public ThreadGroupFilter(ThreadGroup group, boolean recurse) {
        this._threadGroup = group;
        this._recurse = recurse;
    }

    @Override
    public boolean matches(ThreadInfo threadInfo) {
        if (this._threadGroup.isDestroyed()) {
            return false;
        }
        int cnt = this._threadGroup.activeCount();
        Thread[] threads = new Thread[cnt * 2];
        int actualCnt = this._threadGroup.enumerate(threads, this._recurse);
        for (int i = 0; i < actualCnt; ++i) {
            Thread t = threads[i];
            if (threadInfo.getThreadId() != t.getId()) continue;
            return true;
        }
        return false;
    }
}

