/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import java.lang.management.ThreadInfo;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;

public class ThreadHistory {
    private final long _threadId;
    private final NavigableMap<Date, ThreadInfo> _threadInfos = new ConcurrentSkipListMap<Date, ThreadInfo>();

    public ThreadHistory(long threadId) {
        this._threadId = threadId;
    }

    public ThreadHistory(long threadId, Date ts, ThreadInfo ti) {
        this._threadId = threadId;
        this._threadInfos.put(ts, ti);
    }

    public void add(Date ts, ThreadInfo ti) {
        this._threadInfos.put(ts, ti);
    }

    public long getThreadId() {
        return this._threadId;
    }

    public List<ThreadInfo> getThreadInfo() {
        return new LinkedList<ThreadInfo>(this._threadInfos.values());
    }

    public List<ThreadInfo> getThreadInfo(Date startDate) {
        return new LinkedList<ThreadInfo>(this._threadInfos.tailMap(startDate, true).values());
    }

    public List<ThreadInfo> getThreadInfo(Date startDate, Date endDate) {
        return new LinkedList<ThreadInfo>(this._threadInfos.subMap(startDate, endDate).values());
    }

    public List<ThreadInfo> getThreadInfo(Date startDate, long duration, TimeUnit unit) {
        return this.getThreadInfo(startDate, new Date(startDate.getTime() + unit.toMillis(duration)));
    }

    public void purgeHistory(Date olderThan) {
        this._threadInfos.headMap(olderThan).clear();
    }

    public void purgeHistory(long olderThan, TimeUnit unit) {
        this.purgeHistory(new Date(System.currentTimeMillis() - unit.toMillis(olderThan)));
    }
}

