/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import com.sybase.ua.util.concurrent.ThreadFactories;
import com.sybase.ua.util.concurrent.monitor.ThreadDump;
import com.sybase.ua.util.concurrent.monitor.ThreadDumpSimpleWriter;
import com.sybase.ua.util.concurrent.monitor.ThreadDumpWriter;
import com.sybase.ua.util.concurrent.monitor.ThreadDumpXMLWriter;
import com.sybase.ua.util.concurrent.monitor.ThreadHistory;
import com.sybase.ua.util.concurrent.monitor.ThreadInfoFilter;
import com.sybase.ua.util.concurrent.monitor.ThreadNameFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.MXBean;
import org.apache.log4j.Logger;

@MXBean
public class ThreadMonitor {
    static final ThreadMXBean _threadMXBean = ManagementFactory.getThreadMXBean();
    private final ConcurrentMap<Long, ThreadHistory> _threadHistory = new ConcurrentSkipListMap<Long, ThreadHistory>();
    private final List<ThreadInfoFilter> _detailedThreadInfoInclusionFilters = new LinkedList<ThreadInfoFilter>();
    private long _sampleInterval = 5L;
    private TimeUnit _sampleIntervalTimeUnit = TimeUnit.SECONDS;
    private long _maxHistoryAge = 10L;
    private TimeUnit _maxHistoryTimeUnit = TimeUnit.MINUTES;
    private long _threadsStartedAtMonitorStart;
    private volatile ScheduledExecutorService _executor = null;
    private volatile boolean _managesExecutorLifecycle = false;
    private volatile ScheduledFuture<?> _threadMonitorFuture = null;
    private volatile ScheduledFuture<?> _threadHistoryPurgeFuture = null;
    private ThreadDumpWriter _threadDumpWriter = null;

    public static void main(String[] args) throws Exception {
        ThreadMonitor t = new ThreadMonitor(5L, TimeUnit.SECONDS);
        t.addDetailedThreadInfoFilter(new ThreadNameFilter("main"));
        ThreadDumpSimpleWriter w = new ThreadDumpSimpleWriter();
        t.setThreadDumpWriter(w);
        w.write(t.takeThreadDump());
        t.start();
        Thread.sleep(TimeUnit.MINUTES.toMillis(2L));
    }

    public static boolean enableThreadContentionMonitoring() {
        try {
            if (_threadMXBean.isThreadContentionMonitoringSupported()) {
                if (!_threadMXBean.isThreadContentionMonitoringEnabled()) {
                    _threadMXBean.setThreadContentionMonitoringEnabled(true);
                }
                return true;
            }
        }
        catch (UnsupportedOperationException uoe) {
        }
        catch (SecurityException se) {
            Logger.getLogger(ThreadMonitor.class).warn((Object)"Failed to enable thread CPU timing due to security exception.  User running the VM must have the ManagementPermission(\"control\") permission.  Thread CPU timing disabled.");
        }
        return false;
    }

    public static boolean enableThreadCpuTiming() {
        try {
            if (ThreadMonitor.isThreadCpuTimingSupported()) {
                if (!_threadMXBean.isThreadCpuTimeEnabled()) {
                    _threadMXBean.setThreadCpuTimeEnabled(true);
                }
                return true;
            }
        }
        catch (UnsupportedOperationException uoe) {
        }
        catch (SecurityException se) {
            Logger.getLogger(ThreadMonitor.class).warn((Object)"Failed to enable thread CPU timing due to security exception.  User running the VM must have the ManagementPermission(\"control\") permission.  Thread CPU timing disabled.");
        }
        return false;
    }

    public static final boolean isThreadContentionMonitoringEnabled() {
        return _threadMXBean.isThreadContentionMonitoringSupported() && _threadMXBean.isThreadContentionMonitoringEnabled();
    }

    public static final boolean isThreadCpuTimingSupported() {
        return _threadMXBean.isThreadCpuTimeSupported();
    }

    public static final boolean isThreadCpuTimingEnabled() {
        return _threadMXBean.isThreadCpuTimeSupported() && _threadMXBean.isThreadCpuTimeEnabled();
    }

    public static final Long getCurrentThreadCpuTime() {
        return _threadMXBean.getCurrentThreadCpuTime();
    }

    public static final Long getCurrentThreadUserTime() {
        return _threadMXBean.getCurrentThreadUserTime();
    }

    public static final Long getThreadCpuTime(long tid) {
        return _threadMXBean.getThreadCpuTime(tid);
    }

    public static final Long getThreadUserTime(long tid) {
        return _threadMXBean.getThreadUserTime(tid);
    }

    public static ThreadInfo createRequestingThreadInfo(boolean includeStackAndLockInfo) {
        String threadName = Thread.currentThread().getName();
        long threadId = Thread.currentThread().getId();
        ThreadInfo ti = ThreadMonitor.createThreadInfo(includeStackAndLockInfo, threadId);
        if (ti == null) {
            throw new IllegalStateException("ThreadInfo not available for current Thread id=" + threadId + "(" + threadName + ")");
        }
        return ti;
    }

    public static ThreadInfo createThreadInfo(boolean includeStackAndLockInfo, long threadId) {
        ThreadInfo[] tis;
        long[] threadIds = new long[]{threadId};
        ThreadInfo[] threadInfoArray = tis = includeStackAndLockInfo ? _threadMXBean.getThreadInfo(threadIds, true, true) : _threadMXBean.getThreadInfo(threadIds);
        if (tis == null || tis.length == 0) {
            return null;
        }
        return tis[0];
    }

    public static ThreadInfo[] createThreadInfos(boolean includeStackAndLockInfo, long ... threadIds) {
        ThreadInfo[] tis = includeStackAndLockInfo ? _threadMXBean.getThreadInfo(threadIds, true, true) : _threadMXBean.getThreadInfo(threadIds);
        return tis;
    }

    protected static long[] applyThreadInfoFilters(List<? extends ThreadInfoFilter> filters, ThreadInfo ... threadInfo) {
        long[] filteredThreadIds = new long[threadInfo.length];
        int cnt = 0;
        block0: for (int i = 0; i < threadInfo.length; ++i) {
            ThreadInfo ti = threadInfo[i];
            if (ti == null || filters == null || filters.isEmpty()) continue;
            for (ThreadInfoFilter threadInfoFilter : filters) {
                if (!threadInfoFilter.matches(ti)) continue;
                filteredThreadIds[cnt++] = ti.getThreadId();
                continue block0;
            }
        }
        long[] ret = new long[cnt];
        System.arraycopy(filteredThreadIds, 0, ret, 0, cnt);
        return ret;
    }

    public ThreadMonitor(long sampleInterval, TimeUnit unit) {
        this.setSampleInterval(sampleInterval, unit);
    }

    public ThreadMonitor addDetailedThreadInfoFilter(ThreadInfoFilter filter) {
        this._detailedThreadInfoInclusionFilters.add(filter);
        return this;
    }

    public List<ThreadInfoFilter> getDetailedThreadInfoInclusionFilters() {
        return Collections.unmodifiableList(this._detailedThreadInfoInclusionFilters);
    }

    public long getMaxHistoryAge() {
        return this._maxHistoryAge;
    }

    public TimeUnit getMaxHistoryTimeUnit() {
        return this._maxHistoryTimeUnit;
    }

    public long getSampleInterval() {
        return this._sampleInterval;
    }

    public TimeUnit getSampleIntervalTimeUnit() {
        return this._sampleIntervalTimeUnit;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this._executor;
    }

    public long getThreadsStartedAtMonitorStart() {
        return this._threadsStartedAtMonitorStart;
    }

    public synchronized boolean isRunning() {
        return this._executor != null && !this._executor.isShutdown() && this._threadMonitorFuture != null;
    }

    public ThreadMonitor removeThreadInfoFilter(ThreadInfoFilter filter) {
        this._detailedThreadInfoInclusionFilters.remove(filter);
        return this;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        if (this._executor != null && !this._executor.isShutdown()) {
            throw new IllegalStateException("Existing ThreadMonitor executor must be shutdown before setting a new executor");
        }
        this._executor = executor;
    }

    public void setMaxHistoryAge(long maxHistoryAge, TimeUnit unit) {
        this._maxHistoryAge = maxHistoryAge;
        this._maxHistoryTimeUnit = unit;
    }

    public void setSampleInterval(long sampleInterval, TimeUnit unit) {
        this._sampleInterval = sampleInterval;
        this._sampleIntervalTimeUnit = unit;
    }

    public ThreadMonitor setThreadDumpWriter(ThreadDumpWriter writer) {
        this._threadDumpWriter = writer;
        return this;
    }

    public synchronized void start() {
        boolean contentionMonitoringEnabled = ThreadMonitor.enableThreadContentionMonitoring();
        boolean cpuTimingEnabled = ThreadMonitor.enableThreadCpuTiming();
        this._threadsStartedAtMonitorStart = _threadMXBean.getTotalStartedThreadCount();
        if (this._executor == null) {
            this._managesExecutorLifecycle = true;
            this._executor = this.getDefaultExecutor();
        } else {
            this._managesExecutorLifecycle = false;
        }
        this._threadMonitorFuture = this.getScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ThreadDump td = new ThreadDump(ThreadMonitor.this._detailedThreadInfoInclusionFilters);
                ThreadMonitor.this.addMonitoredThreadsToHistory(td);
                ThreadMonitor.this.getThreadDumpWriter().write(td);
            }
        }, 1L, this._sampleInterval, this._sampleIntervalTimeUnit);
        this._threadHistoryPurgeFuture = this.getScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (ThreadMonitor.this._threadHistory.size() > 0) {
                    for (Long threadId : ThreadMonitor.this._threadHistory.keySet()) {
                        ThreadHistory th = (ThreadHistory)ThreadMonitor.this._threadHistory.get(threadId);
                        th.purgeHistory(ThreadMonitor.this.getMaxHistoryAge(), ThreadMonitor.this.getMaxHistoryTimeUnit());
                    }
                }
            }
        }, 30L, this._sampleInterval * 10L, this._sampleIntervalTimeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        if (this._threadMonitorFuture != null) {
            this._threadMonitorFuture.cancel(true);
            this._threadMonitorFuture = null;
        }
        if (this._threadHistoryPurgeFuture != null) {
            this._threadHistoryPurgeFuture.cancel(true);
            this._threadHistoryPurgeFuture = null;
        }
        if (this._managesExecutorLifecycle) {
            this._executor.shutdown();
            try {
                if (!this._executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this._executor.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this._executor.shutdownNow();
            }
            finally {
                this._executor = null;
            }
        }
    }

    public ThreadDump takeThreadDump() {
        return new ThreadDump(this._detailedThreadInfoInclusionFilters);
    }

    protected void addMonitoredThreadsToHistory(ThreadDump dump) {
        ThreadInfo[] monitoredThreadDetails = dump.getMonitoredThreadDetails();
        if (monitoredThreadDetails != null && monitoredThreadDetails.length > 0) {
            for (ThreadInfo ti : monitoredThreadDetails) {
                ThreadHistory th = null;
                if (!this._threadHistory.containsKey(ti.getThreadId())) {
                    th = new ThreadHistory(ti.getThreadId());
                    this._threadHistory.put(ti.getThreadId(), th);
                } else {
                    th = (ThreadHistory)this._threadHistory.get(ti.getThreadId());
                }
                th.add(dump.getTimestampAsDate(), ti);
            }
        }
    }

    private ScheduledExecutorService getDefaultExecutor() {
        return Executors.newScheduledThreadPool(1, ThreadFactories.createThreadFactory("scc-thread-monitor"));
    }

    private ThreadDumpWriter getThreadDumpWriter() {
        if (this._threadDumpWriter == null) {
            this._threadDumpWriter = new ThreadDumpXMLWriter();
        }
        return this._threadDumpWriter;
    }
}

