/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import com.sybase.ua.util.concurrent.monitor.ThreadInfoFilter;
import java.lang.management.ThreadInfo;
import java.util.regex.Pattern;

public class ThreadNameFilter
implements ThreadInfoFilter {
    private final String[] _threadNameRegex;

    public ThreadNameFilter(String ... threadNameRegex) {
        for (String regex : threadNameRegex) {
            Pattern.compile(regex);
        }
        this._threadNameRegex = new String[threadNameRegex.length];
        System.arraycopy(threadNameRegex, 0, this._threadNameRegex, 0, threadNameRegex.length);
    }

    @Override
    public boolean matches(ThreadInfo threadInfo) {
        for (String regex : this._threadNameRegex) {
            if (!threadInfo.getThreadName().matches(regex)) continue;
            return true;
        }
        return false;
    }
}

