/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent.monitor;

import com.sybase.ua.util.concurrent.monitor.ProcessCpuTimer;
import com.sybase.ua.util.concurrent.monitor.ThreadMonitor;
import java.io.Serializable;
import java.lang.management.ThreadInfo;
import org.apache.log4j.Logger;

public class ThreadTaskExecutionTimer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ThreadInfo _startTimeOwningThreadInfo;
    private ThreadInfo _completedTimeOwningThreadInfo = null;
    private final Long _startTimeNanos;
    private Long _completedTimeNanos = null;
    private final Long _threadCpuTimeStartNanos;
    private Long _threadCpuTimeCompletedNanos = null;
    private final Long _processCpuTimeStartNanos;
    private Long _processCpuTimeCompletedNanos = null;

    public ThreadTaskExecutionTimer() {
        this(Thread.currentThread());
    }

    public ThreadTaskExecutionTimer(Thread owningThread) {
        this(owningThread.getId());
    }

    public ThreadTaskExecutionTimer(long owningThreadId) {
        this(owningThreadId, false);
    }

    public ThreadTaskExecutionTimer(long owningThreadId, boolean includeStackAndLockInfo) {
        this._startTimeOwningThreadInfo = ThreadMonitor.createThreadInfo(includeStackAndLockInfo, owningThreadId);
        if (this._startTimeOwningThreadInfo == null) {
            throw new IllegalStateException("Specified owning thread ID (" + owningThreadId + ") does not exist.");
        }
        this._startTimeNanos = System.nanoTime();
        this._threadCpuTimeStartNanos = ThreadMonitor.getThreadCpuTime(owningThreadId);
        this._processCpuTimeStartNanos = ProcessCpuTimer.getProcessCpuTime();
    }

    public long getOwningThreadId() {
        return this._startTimeOwningThreadInfo.getThreadId();
    }

    public String getOwningThreadName() {
        return this._startTimeOwningThreadInfo.getThreadName();
    }

    public ThreadInfo getCurrentOwningThreadInfo(boolean includeStackAndLockInfo) {
        return ThreadMonitor.createThreadInfo(includeStackAndLockInfo, this.getOwningThreadId());
    }

    public boolean isProcessCPUTimeSupported() {
        return ProcessCpuTimer.isProcessCpuTimeSupported();
    }

    public boolean isThreadCpuTimingEnabled() {
        return ThreadMonitor.isThreadCpuTimingEnabled();
    }

    public boolean isThreadContentionMonitoringEnabled() {
        return ThreadMonitor.isThreadContentionMonitoringEnabled();
    }

    public synchronized void stop() {
        if (this.isStopped()) {
            throw new IllegalStateException("Timer is already stopped.");
        }
        this._processCpuTimeCompletedNanos = ProcessCpuTimer.getProcessCpuTime();
        this._threadCpuTimeCompletedNanos = ThreadMonitor.getThreadCpuTime(this._startTimeOwningThreadInfo.getThreadId());
        this._completedTimeOwningThreadInfo = ThreadMonitor.createThreadInfo(false, this._startTimeOwningThreadInfo.getThreadId());
        this._completedTimeNanos = System.nanoTime();
        if (Thread.currentThread().getId() != this._startTimeOwningThreadInfo.getThreadId()) {
            Logger.getLogger(ThreadTaskExecutionTimer.class).warn((Object)String.format("TaskExecutionTimer stopped by thread %d:%s which is not the creating(owning) thread %d:%s. Thread CPU Timing is calculated on the owning thread and may not be accurate if the task is not actually run on that thread.", Thread.currentThread().getId(), Thread.currentThread().getName(), this._startTimeOwningThreadInfo.getThreadId(), this._startTimeOwningThreadInfo.getThreadName()));
        }
    }

    public Long elapsed() {
        Long ctime = this.isStopped() ? this.getCompletedTimeNanos() : System.nanoTime();
        return ctime - this.getStartTimeNanos();
    }

    public Long elapsedProcessCpuTime() {
        Long pctime = this.isStopped() ? this.getProcessCpuTimeCompletedNanos() : ProcessCpuTimer.getProcessCpuTime();
        return pctime - this.getProcessCpuTimeStartNanos();
    }

    public Long elapsedThreadCpuTime() {
        Long tctime = this.isStopped() ? this.getThreadCpuTimeCompletedNanos() : ThreadMonitor.getThreadCpuTime(this._startTimeOwningThreadInfo.getThreadId());
        return tctime - this.getThreadCpuTimeStartNanos();
    }

    public Long getThreadBlockedTime() {
        ThreadInfo ti = this.isStopped() ? this._completedTimeOwningThreadInfo : ThreadMonitor.createThreadInfo(false, this._startTimeOwningThreadInfo.getThreadId());
        return ti.getBlockedTime() - this._startTimeOwningThreadInfo.getBlockedTime();
    }

    public Long getThreadWaitedTime() {
        ThreadInfo ti = this.isStopped() ? this._completedTimeOwningThreadInfo : ThreadMonitor.createThreadInfo(false, this._startTimeOwningThreadInfo.getThreadId());
        return ti.getWaitedTime() - this._startTimeOwningThreadInfo.getWaitedTime();
    }

    public Long getThreadBlockedCount() {
        ThreadInfo ti = this.isStopped() ? this._completedTimeOwningThreadInfo : ThreadMonitor.createThreadInfo(false, this._startTimeOwningThreadInfo.getThreadId());
        return ti.getBlockedCount() - this._startTimeOwningThreadInfo.getBlockedCount();
    }

    public Long getThreadWaitedCount() {
        ThreadInfo ti = this.isStopped() ? this._completedTimeOwningThreadInfo : ThreadMonitor.createThreadInfo(false, this._startTimeOwningThreadInfo.getThreadId());
        return ti.getWaitedCount() - this._startTimeOwningThreadInfo.getWaitedCount();
    }

    public final Long getCompletedTimeNanos() {
        return this._completedTimeNanos;
    }

    public Long getProcessCpuTimeStartNanos() {
        return this._processCpuTimeStartNanos;
    }

    public Long getProcessCpuTimeCompletedNanos() {
        return this._processCpuTimeCompletedNanos;
    }

    public Long getThreadCpuTimeStartNanos() {
        return this._threadCpuTimeStartNanos;
    }

    public Long getThreadCpuTimeCompletedNanos() {
        return this._threadCpuTimeCompletedNanos;
    }

    public final Long getStartTimeNanos() {
        return this._startTimeNanos;
    }

    public final synchronized boolean isStopped() {
        return this._completedTimeNanos != null;
    }

    public double getProcessCpuUsagePercentage() {
        Long elapsedTime = this.elapsed();
        Long processCpuTime = this.elapsedProcessCpuTime();
        if (elapsedTime == 0L) {
            return 0.0;
        }
        if (processCpuTime < 0L) {
            return -1.0;
        }
        return processCpuTime / elapsedTime * 100L;
    }

    public double getThreadCpuUsagePercentage() {
        Long elapsedTime = this.elapsed();
        Long threadCpuTime = this.elapsedThreadCpuTime();
        if (elapsedTime == 0L) {
            return 0.0;
        }
        if (threadCpuTime < 0L) {
            return -1.0;
        }
        return threadCpuTime / elapsedTime * 100L;
    }
}

