/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.jdom;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class JDomUtil {
    public static Document getDocument(String xmlString) throws IOException {
        SAXBuilder builder = null;
        Document document = null;
        try {
            builder = JDomUtil.getJDOMParser(false);
            StringReader inputStream = new StringReader(xmlString);
            document = builder.build((Reader)inputStream);
            inputStream.close();
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
        }
        return document;
    }

    public static Document getDocument(Reader xmlReader) throws IOException {
        SAXBuilder builder = null;
        Document document = null;
        try {
            builder = JDomUtil.getJDOMParser(false);
            document = builder.build(xmlReader);
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
        }
        return document;
    }

    public static DocumentBuilder getDOMParser(boolean validating) throws ParserConfigurationException, SAXException {
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setValidating(validating);
            f.setNamespaceAware(true);
            DocumentBuilder parser = f.newDocumentBuilder();
            return parser;
        }
        catch (ParserConfigurationException e) {
            System.out.println("XMLHelper.getDOMParser caught: " + e);
            throw e;
        }
    }

    public static SAXBuilder getJDOMParser(boolean validating) throws JDOMException {
        return new SAXBuilder(validating);
    }

    public static SAXParser getSAXParser(boolean validating) throws ParserConfigurationException, SAXException {
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setValidating(validating);
            f.setNamespaceAware(true);
            return f.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println("XMLHelper.getSAXParser caught: " + e);
            throw e;
        }
    }

    public static String replaceAmpersandSequence(String xmlString) {
        String xmlReturnString = "";
        int ndx = 0;
        while (ndx < xmlString.length()) {
            if (xmlString.charAt(ndx) == '&') {
                if (xmlString.substring(ndx, ndx + 4).compareTo("&lt;") == 0) {
                    xmlReturnString = xmlReturnString + "<";
                    ndx += 4;
                    continue;
                }
                if (xmlString.substring(ndx, ndx + 4).compareTo("&gt;") == 0) {
                    xmlReturnString = xmlReturnString + ">";
                    ndx += 4;
                    continue;
                }
            }
            xmlReturnString = xmlReturnString + xmlString.substring(ndx, ndx + 1);
            ++ndx;
        }
        return xmlReturnString;
    }

    public static String toString(Document document) throws IOException {
        return JDomUtil.toString(document, null);
    }

    public static String toString(Document document, String encoding) throws IOException {
        Format format = Format.getPrettyFormat();
        if (encoding != null) {
            format.setEncoding(encoding);
        }
        XMLOutputter outputter = new XMLOutputter(format);
        StringWriter stringWriter = new StringWriter();
        outputter.output(document, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        stringWriter.close();
        return xmlString;
    }

    public static String toString(Element element) throws IOException {
        return JDomUtil.toString(element, null);
    }

    public static String toString(Element element, String encoding) throws IOException {
        Format format = Format.getPrettyFormat();
        format.setEncoding(encoding);
        XMLOutputter outputter = new XMLOutputter(format);
        StringWriter stringWriter = new StringWriter();
        outputter.output(element, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        stringWriter.close();
        return xmlString;
    }

    private JDomUtil() {
    }
}

