/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.jdom;

import com.sybase.ua.util.jdom.JDomUtil;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLResult
implements Serializable {
    static final long serialVersionUID = -6276183654834050558L;
    public static final String XML_ROOT_ELEMENT = "XMLRESULT";
    public static final String XML_METAINFO_ROOT_ELEMENT = "METAINFO";
    public static final String XML_METAINFO_ATTRIBUTE_ELEMENT = "ATTRIBUTE";
    public static final String XML_METAINFO_ATTRIBUTE_ATTRIBUTE_NAME = "name";
    public static final String XML_METAINFO_ATTRIBUTE_ATTRIBUTE_VALUE = "value";
    public static final String XML_RESULT_ROOT_ELEMENT = "RESULTSET";
    public static final String XML_RESULT_ROW_ELEMENT = "ROW";
    public static final String XML_RESULT_COLUMN_ELEMENT = "COLUMN";
    public static final String XML_RESULT_COLUMN_ATTRIBUTE_NAME = "name";
    public static final String XML_RESULT_COLUMN_ATTRIBUTE_LABEL = "label";
    public static final String XML_RESULT_COLUMN_ATTRIBUTE_TYPE = "type";
    public static final String XML_RESULT_COLUMN_ATTRIBUTE_TYPENAME = "typename";
    public static final String XML_RESULT_COLUMN_ATTRIBUTE_TYPECLASS = "typeclass";
    public static final String XML_RESULT_COLUMN_ATTRIBUTE_SCALE = "scale";
    public static final String XML_RESULT_COLUMN_ATTRIBUTE_PRECISION = "precision";
    private Document document = null;
    private Element resultSetElement = null;
    private Element metaInfoElement = null;
    private final Hashtable columnKeys = new Hashtable();
    private SortedMap[] rows;

    public XMLResult(Document document) {
        this.document = document;
        Element rootElement = document.getRootElement();
        this.metaInfoElement = rootElement.getChild(XML_METAINFO_ROOT_ELEMENT);
        this.resultSetElement = rootElement.getChild(XML_RESULT_ROOT_ELEMENT);
        this.loadColumnNames();
    }

    public XMLResult(ResultSet resultSet) throws SQLException {
        this(null, resultSet);
    }

    public XMLResult(SortedMap metaInfoMap, ResultSet resultSet) throws SQLException {
        Element rootElement = new Element(XML_ROOT_ELEMENT);
        this.document = new Document(rootElement);
        if (metaInfoMap != null && !metaInfoMap.isEmpty()) {
            this.metaInfoElement = new Element(XML_METAINFO_ROOT_ELEMENT);
            Set keyset = metaInfoMap.keySet();
            for (String name : keyset) {
                String value = (String)metaInfoMap.get(name);
                Element attribElement = new Element(XML_METAINFO_ATTRIBUTE_ELEMENT);
                attribElement.setAttribute("name", name);
                attribElement.setAttribute(XML_METAINFO_ATTRIBUTE_ATTRIBUTE_VALUE, value);
                this.metaInfoElement.addContent((Content)attribElement);
            }
            rootElement.addContent((Content)this.metaInfoElement);
        }
        this.resultSetElement = new Element(XML_RESULT_ROOT_ELEMENT);
        ResultSetMetaData rsMetaData = resultSet.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        int rowCount = 0;
        while (resultSet.next()) {
            Element rowElement = new Element(XML_RESULT_ROW_ELEMENT);
            ++rowCount;
            for (int ndx = 1; ndx <= columnCount; ++ndx) {
                Object obj;
                Element columnElement = new Element(XML_RESULT_COLUMN_ELEMENT);
                if (rowCount == 1) {
                    columnElement.setAttribute("name", rsMetaData.getColumnName(ndx));
                    columnElement.setAttribute(XML_RESULT_COLUMN_ATTRIBUTE_LABEL, rsMetaData.getColumnLabel(ndx));
                    columnElement.setAttribute(XML_RESULT_COLUMN_ATTRIBUTE_TYPE, Integer.toString(rsMetaData.getColumnType(ndx)));
                    columnElement.setAttribute(XML_RESULT_COLUMN_ATTRIBUTE_TYPENAME, rsMetaData.getColumnTypeName(ndx));
                    columnElement.setAttribute(XML_RESULT_COLUMN_ATTRIBUTE_TYPECLASS, rsMetaData.getColumnClassName(ndx));
                    columnElement.setAttribute(XML_RESULT_COLUMN_ATTRIBUTE_SCALE, Integer.toString(rsMetaData.getScale(ndx)));
                    columnElement.setAttribute(XML_RESULT_COLUMN_ATTRIBUTE_PRECISION, Integer.toString(rsMetaData.getPrecision(ndx)));
                }
                if ((obj = resultSet.getObject(ndx)) != null) {
                    columnElement.setText(obj.toString().trim());
                }
                rowElement.addContent((Content)columnElement);
            }
            this.resultSetElement.addContent((Content)rowElement);
        }
        rootElement.addContent((Content)this.resultSetElement);
        this.loadColumnNames();
    }

    public XMLResult(String xmlString) {
        try {
            this.document = JDomUtil.getDocument(xmlString);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Element rootElement = this.document.getRootElement();
        this.metaInfoElement = rootElement.getChild(XML_METAINFO_ROOT_ELEMENT);
        this.resultSetElement = rootElement.getChild(XML_RESULT_ROOT_ELEMENT);
        this.loadColumnNames();
    }

    public String[] getColumnNames() {
        return this.getRowAttributes("name");
    }

    public SortedMap getMetaInfoAttributes() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (this.metaInfoElement != null) {
            List attributeList = this.metaInfoElement.getChildren(XML_METAINFO_ATTRIBUTE_ELEMENT);
            for (Element attribElement : attributeList) {
                Attribute nameAttribute = attribElement.getAttribute("name");
                String name = nameAttribute.getValue();
                Attribute valueAttribute = attribElement.getAttribute(XML_METAINFO_ATTRIBUTE_ATTRIBUTE_VALUE);
                String value = valueAttribute.getValue();
                if (value == null) continue;
                map.put(name, value);
            }
        }
        return map;
    }

    public String[] getRowAttributes(String attributeName) {
        List rowList = this.resultSetElement.getChildren(XML_RESULT_ROW_ELEMENT);
        List columnList = ((Element)rowList.get(0)).getChildren(XML_RESULT_COLUMN_ELEMENT);
        String[] attributeValue = new String[columnList.size()];
        for (int ndx2 = 0; ndx2 < columnList.size(); ++ndx2) {
            Element columnElement = (Element)columnList.get(ndx2);
            if (columnElement == null) continue;
            Attribute columnAttribute = columnElement.getAttribute(attributeName);
            attributeValue[ndx2] = columnAttribute.getValue();
        }
        return attributeValue;
    }

    public int getRowCount() {
        List rowList = this.resultSetElement.getChildren(XML_RESULT_ROW_ELEMENT);
        return rowList.size();
    }

    public SortedMap[] getRows() {
        List rowList = this.resultSetElement.getChildren(XML_RESULT_ROW_ELEMENT);
        SortedMap[] sortedMapArray = new TreeMap[rowList.size()];
        for (int ndx1 = 0; ndx1 < rowList.size(); ++ndx1) {
            Element rowElement = (Element)rowList.get(ndx1);
            sortedMapArray[ndx1] = new TreeMap();
            List columnList = rowElement.getChildren(XML_RESULT_COLUMN_ELEMENT);
            for (int ndx2 = 0; ndx2 < columnList.size(); ++ndx2) {
                Object value = columnList.get(ndx2);
                if (value == null) continue;
                sortedMapArray[ndx1].put(new Integer(ndx2), value);
            }
        }
        return sortedMapArray;
    }

    public Object[][] getRowsByIndex() {
        List rowList = this.resultSetElement.getChildren(XML_RESULT_ROW_ELEMENT);
        if (rowList.size() == 0) {
            return null;
        }
        int numberOfColumns = ((Element)rowList.get(0)).getChildren(XML_RESULT_COLUMN_ELEMENT).size();
        Object[][] indexArray = new Object[rowList.size()][numberOfColumns];
        for (int ndx1 = 0; ndx1 < rowList.size(); ++ndx1) {
            Element rowElement = (Element)rowList.get(ndx1);
            List columnList = rowElement.getChildren(XML_RESULT_COLUMN_ELEMENT);
            for (int ndx2 = 0; ndx2 < columnList.size(); ++ndx2) {
                if (columnList.get(ndx2) == null) continue;
                indexArray[ndx1][ndx2] = ((Element)columnList.get(ndx2)).getTextTrim();
            }
        }
        return indexArray;
    }

    public String getValue(int index, String colname) {
        String colvalue = null;
        try {
            if (this.rows.length > 0) {
                SortedMap row = this.rows[index];
                Integer key = (Integer)this.columnKeys.get(colname);
                colvalue = ((Element)row.get(key)).getValue();
            }
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        return colvalue;
    }

    public boolean isLimitedByMaxRows() {
        return false;
    }

    public String toXML() throws IOException {
        return JDomUtil.toString(this.document);
    }

    private void loadColumnNames() {
        try {
            this.rows = this.getRows();
            if (this.rows.length > 0) {
                SortedMap row = this.rows[0];
                Set keys = row.keySet();
                for (Integer key : keys) {
                    Element col = (Element)row.get(key);
                    String colname = col.getAttributeValue("name");
                    this.columnKeys.put(colname, key);
                }
            }
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
    }
}

