/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.ldap;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDAPConnection {
    public static final String PROP_HOST = "HOST";
    public static final String PROP_PORT = "PORT";
    public static final String PROP_USER_DN = "USER_DN";
    public static final String PROP_PASSWORD = "PASSWORD";
    public static final String PROP_AUTHENTICATION_METHOD = "AUTHENTICATION_METHOD";
    public static final String PROP_LDAP_FACTORY = "LDAP_FACTORY";
    public static final String PROP_BASE_DN = "BASE_DN";
    private static final String DEFAULT_LDAP_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String DEFAULT_AUTHENTICATION_METHOD = "simple";
    public static final String DEFAULT_LDAP_PORT = "389";
    private static Log log = LogFactory.getLog(LDAPConnection.class);
    private String host;
    private String port = "389";
    private String userDn;
    private String password;
    private String authenticationmethod = "simple";
    private String ldapFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private DirContext context;
    private boolean connected;

    public static LDAPConnection createLDAPConnection(Properties prop) throws NamingException {
        LDAPConnection conn = new LDAPConnection();
        if (prop != null) {
            String propAuthenMethod;
            String propLdapFactory;
            String propPasswd;
            String propUserDn;
            String propPort;
            String propHost = prop.getProperty(PROP_HOST);
            if (propHost != null) {
                conn.setHost(propHost);
            }
            if ((propPort = prop.getProperty(PROP_PORT)) != null) {
                conn.setPort(propPort);
            }
            if ((propUserDn = prop.getProperty(PROP_USER_DN)) != null) {
                conn.setUserDn(propUserDn);
            }
            if ((propPasswd = prop.getProperty(PROP_PASSWORD)) != null) {
                conn.setPassword(propPasswd);
            }
            if ((propLdapFactory = prop.getProperty(PROP_LDAP_FACTORY)) != null) {
                conn.setLdapFactory(propLdapFactory);
            }
            if ((propAuthenMethod = prop.getProperty(PROP_AUTHENTICATION_METHOD)) != null) {
                conn.setAuthenticationmethod(propAuthenMethod);
            }
        }
        return conn;
    }

    private LDAPConnection() {
    }

    public void connect() throws NamingException {
        if (this.isConnected()) {
            log.debug((Object)"Already connected. Do nothing.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.getLdapFactory());
        env.put("java.naming.provider.url", this.getUrl());
        env.put("java.naming.security.authentication", this.getAuthenticationmethod());
        if (this.getUserDn() != null) {
            env.put("java.naming.security.principal", this.getUserDn());
        }
        if (this.getPassword() != null) {
            env.put("java.naming.security.credentials", this.getPassword());
        }
        this.context = new InitialDirContext(env);
        this.setConnected(true);
    }

    public void disconnect() throws NamingException {
        if (!this.isConnected()) {
            log.debug((Object)"Not connected yet. Do nothing.");
        }
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
        this.setConnected(false);
    }

    public String getAuthenticationmethod() {
        return this.authenticationmethod;
    }

    public DirContext getDirectoryContext() {
        return this.context;
    }

    public String getHost() {
        return this.host;
    }

    public String getLdapFactory() {
        return this.ldapFactory;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public String getUrl() {
        String url = "ldap://" + this.getHost() + ":" + this.getPort();
        return url;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setAuthenticationmethod(String authenticationmethod) {
        this.authenticationmethod = authenticationmethod;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setLdapFactory(String ldapFactory) {
        this.ldapFactory = ldapFactory;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }
}

