/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.ldap;

import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDAPNode {
    private String distinguishedName;
    private String commonName;
    private DirContext directoryContext;
    private Attributes attributes;
    protected Log log;

    public LDAPNode(String distinguishedName, DirContext directoryContext) {
        this.distinguishedName = distinguishedName;
        this.directoryContext = directoryContext;
        this.attributes = new BasicAttributes();
        this.log = LogFactory.getLog(this.getClass());
    }

    public LDAPNode(String commonName, String distinguishedName, DirContext directoryContext) {
        this(distinguishedName, directoryContext);
        this.commonName = commonName;
    }

    public void create() throws NamingException {
        this.directoryContext.bind(this.distinguishedName, null, this.getAttributes());
        this.log.debug((Object)("Created node " + this.getCommonName()));
    }

    public void create(Attributes attrs) throws NamingException {
        this.setAttributes(attrs);
        this.create();
    }

    public void create(Object obj) throws NamingException {
        this.directoryContext.bind(this.distinguishedName, obj, this.getAttributes());
        this.log.debug((Object)("Created node " + this.getCommonName()));
    }

    public void create(Object obj, Attributes attrs) throws NamingException {
        this.setAttributes(attrs);
        this.create(obj);
    }

    public void delete() throws NamingException {
        this.directoryContext.unbind(this.distinguishedName);
        this.log.debug((Object)("Deleted node " + this.getCommonName()));
    }

    public void dispose() {
        this.directoryContext = null;
        this.distinguishedName = null;
        this.commonName = null;
        this.attributes = null;
    }

    public boolean exists() throws NamingException {
        boolean nodeExists = true;
        Object nodeObject = null;
        try {
            nodeObject = this.directoryContext.lookup(this.distinguishedName);
        }
        catch (NameNotFoundException e) {
            nodeExists = false;
        }
        if (nodeObject == null) {
            nodeExists = false;
        }
        return nodeExists;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public DirContext getDirectoryContext() {
        return this.directoryContext;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public void setDirectoryContext(DirContext directoryContext) {
        this.directoryContext = directoryContext;
    }

    public void setDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    public void update() throws NamingException {
        this.directoryContext.modifyAttributes(this.distinguishedName, 2, this.getAttributes());
        this.log.debug((Object)("Updated node " + this.getCommonName()));
    }

    public void update(Attributes attrs) throws NamingException {
        this.setAttributes(attrs);
        this.update();
    }
}

