/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.logging.bridge;

import com.sybase.ua.util.logging.bridge.DefaultLogRecordConverter;
import com.sybase.ua.util.logging.bridge.LogRecordConverter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class DefaultJavaToLog4jBridgeHandler
extends Handler {
    private static final DefaultJavaToLog4jBridgeHandler DEFAULT = new DefaultJavaToLog4jBridgeHandler(DefaultLogRecordConverter.getInstance());
    private final LogRecordConverter _logRecordConverter;

    public static final DefaultJavaToLog4jBridgeHandler getDefault() {
        return DEFAULT;
    }

    public DefaultJavaToLog4jBridgeHandler() {
        this(null);
    }

    public DefaultJavaToLog4jBridgeHandler(LogRecordConverter recordConverter) {
        this._logRecordConverter = recordConverter != null ? recordConverter : DefaultLogRecordConverter.getInstance();
    }

    LogRecordConverter getLogRecordConverter() {
        return this._logRecordConverter;
    }

    @Override
    public void publish(LogRecord logRecord) {
        Logger localLogger = this.getLog4jLogger(logRecord);
        Level recordLog4jLevel = this._logRecordConverter.getLogLevelConverter().convertJavaLogLevel(logRecord.getLevel());
        if (recordLog4jLevel.isGreaterOrEqual((Priority)localLogger.getEffectiveLevel())) {
            LoggingEvent clr = this._logRecordConverter.convertJava(logRecord);
            localLogger.callAppenders(clr);
        }
    }

    protected String getLoggerName(LogRecord logRecord) {
        String loggerName = logRecord.getLoggerName();
        if (loggerName == null) {
            loggerName = "";
        }
        return loggerName;
    }

    protected Logger getLog4jLogger(LogRecord logRecord) {
        return Logger.getLogger((String)this.getLoggerName(logRecord));
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }
}

