/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.logging.bridge;

import com.sybase.ua.util.logging.bridge.DefaultLogLevelConverter;
import com.sybase.ua.util.logging.bridge.LogLevelConverter;
import com.sybase.ua.util.logging.bridge.LogRecordConverter;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class DefaultLogRecordConverter
implements LogRecordConverter {
    private static final DefaultLogRecordConverter DEFAULT = new DefaultLogRecordConverter();
    private final LogLevelConverter _logLevelConverter;
    private final Formatter _logMessageFormatter = new SimpleFormatter();
    private Map<String, ResourceBundle> _resourceBundleCache = new WeakHashMap<String, ResourceBundle>();

    public static final DefaultLogRecordConverter getInstance() {
        return DEFAULT;
    }

    public static final DefaultLogRecordConverter getInstance(LogLevelConverter levelConverter) {
        return new DefaultLogRecordConverter(levelConverter);
    }

    protected DefaultLogRecordConverter() {
        this(DefaultLogLevelConverter.getInstance());
    }

    protected DefaultLogRecordConverter(LogLevelConverter levelConverter) {
        this._logLevelConverter = levelConverter != null ? levelConverter : DefaultLogLevelConverter.getInstance();
    }

    @Override
    public LoggingEvent convertJava(LogRecord logRecord) {
        String loggerName = logRecord.getLoggerName();
        if (loggerName == null) {
            loggerName = "";
        }
        Logger logger = Logger.getLogger((String)loggerName);
        String sourceClassName = logRecord.getSourceClassName();
        String sourceMethodName = logRecord.getSourceMethodName();
        LocationInfo locationInfo = new LocationInfo("NA", sourceClassName, sourceMethodName, "NA");
        String ndc = null;
        String threadName = Thread.currentThread().getName();
        ThrowableInformation throwableInformation = logRecord.getThrown() == null ? null : new ThrowableInformation(logRecord.getThrown());
        String localizedMessage = this.formatMessage(logRecord);
        LoggingEvent clr = new LoggingEvent(loggerName, (Category)logger, logRecord.getMillis(), this._logLevelConverter.convertJavaLogLevel(logRecord.getLevel()), (Object)localizedMessage, threadName, throwableInformation, ndc, locationInfo, (Map)new Properties());
        return clr;
    }

    protected String formatMessage(LogRecord logRecord) {
        if (logRecord.getResourceBundle() == null && logRecord.getResourceBundleName() != null) {
            ResourceBundle bundle = this.findResourceBundle(logRecord.getResourceBundleName());
            logRecord.setResourceBundle(bundle);
        }
        return this._logMessageFormatter.formatMessage(logRecord);
    }

    @Override
    public LogRecord convertLog4j(LoggingEvent logRecord) {
        ThrowableInformation ti;
        LogRecord clr = new LogRecord(this._logLevelConverter.convertLog4JLevel(logRecord.getLevel()), logRecord.getMessage().toString());
        clr.setLoggerName(logRecord.getLoggerName());
        clr.setMillis(logRecord.getTimeStamp());
        LocationInfo locInfo = logRecord.getLocationInformation();
        if (locInfo != null) {
            clr.setSourceClassName(locInfo.getClassName());
            clr.setSourceMethodName(locInfo.getMethodName() + ":(" + locInfo.getLineNumber() + ")");
        }
        if ((ti = logRecord.getThrowableInformation()) != null) {
            clr.setThrown(ti.getThrowable());
        }
        return clr;
    }

    @Override
    public LogLevelConverter getLogLevelConverter() {
        return this._logLevelConverter;
    }

    private synchronized ResourceBundle findResourceBundle(String name) {
        if (name == null) {
            return null;
        }
        ResourceBundle bundle = this._resourceBundleCache.get(name);
        if (bundle != null) {
            return bundle;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            bundle = ResourceBundle.getBundle(name, Locale.getDefault(), cl);
            this._resourceBundleCache.put(name, bundle);
            return bundle;
        }
        catch (MissingResourceException ex) {
            Class<?> sunReflectClass = null;
            Method getCallerClass = null;
            try {
                sunReflectClass = Class.forName("sun.reflect.Reflection");
                getCallerClass = sunReflectClass.getMethod("getCallerClass", Integer.TYPE);
                int ix = 0;
                while (true) {
                    Class clz = null;
                    try {
                        clz = (Class)getCallerClass.invoke(null, ix);
                    }
                    catch (Exception e) {
                        break;
                    }
                    if (clz != null) {
                        ClassLoader cl2 = clz.getClassLoader();
                        if (cl2 == null) {
                            cl2 = ClassLoader.getSystemClassLoader();
                        }
                        if (cl != cl2) {
                            cl = cl2;
                            try {
                                bundle = ResourceBundle.getBundle(name, Locale.getDefault(), cl);
                                this._resourceBundleCache.put(name, bundle);
                                return bundle;
                            }
                            catch (MissingResourceException ex2) {
                                // empty catch block
                            }
                        }
                        ++ix;
                        continue;
                    }
                    break;
                }
            }
            catch (ClassNotFoundException cnfe) {
                sunReflectClass = null;
                getCallerClass = null;
            }
            catch (NoSuchMethodException e) {
                sunReflectClass = null;
                getCallerClass = null;
            }
            return null;
        }
    }
}

