/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.logging.bridge;

import com.sybase.ua.util.logging.bridge.DefaultJavaToLog4jBridgeHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JavaBridgedLogger
extends Logger {
    private final org.apache.log4j.Logger _log4jLogger;
    private final DefaultJavaToLog4jBridgeHandler _bridgeHandler;

    public JavaBridgedLogger(DefaultJavaToLog4jBridgeHandler bridgeHandler, String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this._log4jLogger = org.apache.log4j.Logger.getLogger((String)name);
        this._bridgeHandler = bridgeHandler;
        super.setLevel(this.getLevel());
    }

    @Override
    public synchronized void addHandler(Handler handler) throws SecurityException {
        if (handler instanceof DefaultJavaToLog4jBridgeHandler) {
            super.addHandler(handler);
        }
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    @Override
    public synchronized Handler[] getHandlers() {
        return new Handler[]{this._bridgeHandler};
    }

    @Override
    public Level getLevel() {
        return this._bridgeHandler.getLogRecordConverter().getLogLevelConverter().convertLog4JLevel(this._log4jLogger.getEffectiveLevel());
    }

    @Override
    public synchronized boolean getUseParentHandlers() {
        return false;
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < super.getLevel().intValue()) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, String.format("ENTRY [%s.%s()]", sourceClass, sourceMethod));
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (Level.FINER.intValue() < super.getLevel().intValue()) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logp(Level.FINER, sourceClass, sourceMethod, String.format("ENTRY [%s.%s( {0} )", sourceClass, sourceMethod), params);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (Level.FINER.intValue() < super.getLevel().intValue()) {
            return;
        }
        if (params == null) {
            this.logp(Level.FINER, sourceClass, sourceMethod, String.format("ENTRY [%s.%s()]", sourceClass, sourceMethod));
            return;
        }
        String msg = String.format("ENTRY [%s.%s(", sourceClass, sourceMethod);
        for (int i = 0; i < params.length; ++i) {
            msg = msg + " {" + i + "}";
        }
        msg = msg + ")]";
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < super.getLevel().intValue()) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, String.format("RETURN [%s.%s()", sourceClass, sourceMethod));
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (Level.FINER.intValue() < super.getLevel().intValue()) {
            return;
        }
        Object[] params = new Object[]{result};
        this.logp(Level.FINER, sourceClass, sourceMethod, String.format("RETURN [%s.%s({0})", sourceClass, sourceMethod), params);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (Level.FINER.intValue() < super.getLevel().intValue() || super.getLevel().intValue() == Level.OFF.intValue()) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINER, String.format("THROW [%s.%s(...): %s", sourceClass, sourceMethod, thrown.getMessage()));
        lr.setLoggerName(this.getName());
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        lr.setResourceBundleName(this.findEffectiveResourceBundleName());
        this.log(lr);
    }

    private String findEffectiveResourceBundleName() {
        for (Logger target = this; target != null; target = target.getParent()) {
            String rbn = target.getResourceBundleName();
            if (rbn == null) continue;
            return rbn;
        }
        return null;
    }

    @Override
    public synchronized void removeHandler(Handler handler) throws SecurityException {
        if (!(handler instanceof DefaultJavaToLog4jBridgeHandler)) {
            super.removeHandler(handler);
        }
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
    }

    @Override
    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
    }
}

