/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.logging.bridge;

import com.sybase.ua.util.logging.bridge.DefaultJavaToLog4jBridgeHandler;
import com.sybase.ua.util.logging.bridge.DefaultLogRecordConverter;
import com.sybase.ua.util.logging.bridge.JavaBridgedLogger;
import com.sybase.ua.util.logging.bridge.LogRecordConverter;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class JavaToLog4jBridge {
    public static final void bridgeLogging() {
        JavaToLog4jBridge.bridgeLogging(null);
    }

    public static final void bridgeLogging(LogRecordConverter recordConverter) {
        LogRecordConverter recordConvert = recordConverter != null ? recordConverter : DefaultLogRecordConverter.getInstance();
        DefaultJavaToLog4jBridgeHandler bridgeHandler = new DefaultJavaToLog4jBridgeHandler(recordConvert);
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Level javaLevel = recordConvert.getLogLevelConverter().convertLog4JLevel(org.apache.log4j.Logger.getRootLogger().getLevel());
        rootLogger.setLevel(javaLevel);
        rootLogger.addHandler(bridgeHandler);
        Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
        while (e.hasMoreElements()) {
            String loggerName = e.nextElement();
            if (loggerName.isEmpty()) continue;
            JavaToLog4jBridge.bridgeLogging(bridgeHandler, loggerName);
        }
    }

    public static final void bridgeLogging(DefaultJavaToLog4jBridgeHandler bridgeHandler, String loggerName) {
        Logger javaLogger = LogManager.getLogManager().getLogger(loggerName);
        JavaToLog4jBridge.bridgeLogging(bridgeHandler, javaLogger);
    }

    public static final void bridgeLogging(DefaultJavaToLog4jBridgeHandler bridgeHandler, Logger javaLogger) {
        if (javaLogger == null) {
            return;
        }
        if (javaLogger instanceof JavaBridgedLogger) {
            return;
        }
        org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger((String)javaLogger.getName());
        org.apache.log4j.Level log4jLevel = log4jLogger.getEffectiveLevel();
        Level log4jJavaLevel = bridgeHandler.getLogRecordConverter().getLogLevelConverter().convertLog4JLevel(log4jLevel);
        javaLogger.setLevel(log4jJavaLevel);
        for (Handler h : javaLogger.getHandlers()) {
            javaLogger.removeHandler(h);
        }
        if (!javaLogger.getUseParentHandlers()) {
            javaLogger.addHandler(bridgeHandler);
        }
    }

    private JavaToLog4jBridge() {
    }
}

