/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.process;

import com.sybase.ua.util.process.IProcessResponseHandler;
import com.sybase.ua.util.process.LoggingMessageHandler;
import com.sybase.ua.util.process.ProcessListener;
import com.sybase.ua.util.process.ProcessResponseHandler;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ProcessHandler {
    private static Logger _logger = Logger.getLogger(ProcessHandler.class);
    private String _displayName;
    private final ProcessBuilder _processBuilder;
    private transient Process _process;
    private Integer _exitValue = null;
    private transient Throwable _startupError;
    private final Set<ProcessListener> _processListeners = new HashSet<ProcessListener>();
    private Date _startTime = null;
    private Date _completionTime = null;
    private ProcessStatus _currentStatus = ProcessStatus.unknown;
    private Boolean _reachedEndOfStream = false;
    private final Object _endOfStreamMonitor = new Object();
    private IProcessResponseHandler _processResponseHandler = null;

    public ProcessHandler(String displayName, File dir, List<String> commandArgs) {
        this(displayName, dir, new ProcessBuilder(commandArgs));
    }

    public ProcessHandler(String displayName, File dir, Map<String, String> envp, ProcessBuilder pb) {
        this._displayName = displayName;
        this._processBuilder = pb;
        this.setDirectory(dir);
        this.setEnvironment(envp);
    }

    public ProcessHandler(String displayName, File dir, ProcessBuilder pb) {
        this._displayName = displayName;
        this._processBuilder = pb;
        this.setDirectory(dir);
    }

    public ProcessHandler(String displayName, File dir, String ... commandArgs) {
        this(displayName, dir, new ProcessBuilder(commandArgs));
    }

    public ProcessHandler(String displayName, List<String> commandArgs) {
        this(displayName, new ProcessBuilder(commandArgs));
    }

    public ProcessHandler(String displayName, ProcessBuilder pb) {
        this._displayName = displayName;
        this._processBuilder = pb;
    }

    public ProcessHandler(String displayName, String ... commandArgs) {
        this(displayName, new ProcessBuilder(commandArgs));
    }

    public void addProcessListener(ProcessListener listen) {
        this._processListeners.add(listen);
    }

    public String getCommandAsString() {
        String cmdstr = "";
        for (String arg : this._processBuilder.command()) {
            cmdstr = cmdstr + arg + " ";
        }
        return cmdstr;
    }

    public Date getCompletionTime() {
        return this._completionTime;
    }

    public ProcessStatus getCurrentStatus() {
        return this._currentStatus;
    }

    public File getDirectory() {
        return this._processBuilder.directory();
    }

    public String getDisplayName() {
        if (this._displayName == null) {
            return this.getCommandAsString();
        }
        return this._displayName;
    }

    public Map<String, String> getEnvironment() {
        return this._processBuilder.environment();
    }

    public synchronized Integer getExitValue() {
        if (this._exitValue == null) {
            try {
                if (this._process != null) {
                    this._exitValue = this._process.exitValue();
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return this._exitValue;
    }

    public OutputStream getProcessInputStream() {
        return this._process.getOutputStream();
    }

    public InputStream getProcessOutputStream() {
        return this._process.getInputStream();
    }

    public IProcessResponseHandler getProcessResponseHandler() {
        return this._processResponseHandler;
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public Throwable getStartupError() {
        return this._startupError;
    }

    public synchronized boolean isRunning() {
        return this._process != null && this.getExitValue() == null;
    }

    public synchronized void kill() {
        if (!this.isRunning()) {
            return;
        }
        this._process.destroy();
        this.notifyProcessStatusChange(ProcessStatus.killed);
    }

    public void notifyProcessEndOfStream(ProcessHandler ph) {
        assert (ph.equals(this)) : "Error - Recieved end_of_stream status notification from a different process handler";
        if (!ph.equals(this)) {
            throw new IllegalArgumentException("Error - Recieved end_of_stream status notification from a different process handler");
        }
        this.notifyProcessStatusChange(ProcessStatus.end_of_stream);
    }

    public void setDirectory(File dir) {
        this._processBuilder.directory(dir);
    }

    public void setDisplayName(String name) {
        this._displayName = name;
    }

    public void setEnvironment(Map<String, String> envp) {
        Map<String, String> pbenv = this._processBuilder.environment();
        pbenv.clear();
        pbenv.putAll(envp);
    }

    public void setProcessResponseHandler(IProcessResponseHandler processResponseHandler) {
        this._processResponseHandler = processResponseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startProcess() {
        if (this.isRunning()) {
            throw new IllegalStateException("Process is already running.");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Received request to start process " + this.getDisplayName()));
        }
        this.notifyProcessStatusChange(ProcessStatus.starting);
        this._startupError = null;
        try {
            this._processBuilder.redirectErrorStream(true);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Starting process " + this.getDisplayName() + ": " + this.getCommandAsString()));
            }
            ProcessHandler processHandler = this;
            synchronized (processHandler) {
                this._process = this._processBuilder.start();
                this.notifyProcessStatusChange(ProcessStatus.started);
                new ProcessResponseHandlerThread(this, this.getProcessResponseHandler()).start();
            }
        }
        catch (Exception e) {
            this._startupError = e;
            this.notifyProcessStatusChange(ProcessStatus.startup_failed);
        }
    }

    public void updateEnvironment(String key, String value) {
        if (value == null) {
            this._processBuilder.environment().remove(key);
        } else {
            this._processBuilder.environment().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitForEndOfStream() {
        this.waitForExit();
        Object object = this._endOfStreamMonitor;
        synchronized (object) {
            try {
                while (!this._reachedEndOfStream.booleanValue()) {
                    this._endOfStreamMonitor.wait(1000L);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized Integer waitForExit() {
        if (!this.isRunning()) {
            return this.getExitValue();
        }
        try {
            return this._process.waitFor();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return this.getExitValue();
        }
    }

    protected void setCurrentStatus(ProcessStatus currentStatus) {
        this._currentStatus = currentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProcessStatusChange(ProcessStatus newStatus) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Received Process Status Change Notification: " + (Object)((Object)newStatus)));
        }
        if (this.getCurrentStatus() == newStatus) {
            return;
        }
        switch (newStatus) {
            case initialized: 
            case starting: 
            case started: 
            case interrupted: 
            case killed: 
            case exitted: 
            case startup_failed: {
                this.setCurrentStatus(newStatus);
                break;
            }
            case end_of_stream: {
                Object object = this._endOfStreamMonitor;
                synchronized (object) {
                    this._reachedEndOfStream = true;
                    this._endOfStreamMonitor.notifyAll();
                    break;
                }
            }
        }
        for (ProcessListener pl : this._processListeners) {
            switch (newStatus) {
                case starting: {
                    this._startTime = new Date();
                    pl.processStarting(this);
                    break;
                }
                case started: {
                    pl.processStarted(this);
                    break;
                }
                case interrupted: {
                    pl.processInterrupted(this);
                    break;
                }
                case killed: {
                    pl.processKilled(this);
                    break;
                }
                case exitted: {
                    pl.processCompleted(this, this.getExitValue());
                    this._completionTime = new Date();
                    break;
                }
                case startup_failed: {
                    pl.processStartupFailed(this, this.getStartupError());
                    break;
                }
                case end_of_stream: {
                    pl.processEndOfStream(this);
                    this.waitForExit();
                    this.notifyProcessStatusChange(ProcessStatus.exitted);
                    break;
                }
            }
        }
    }

    protected static class ProcessResponseHandlerThread
    extends Thread {
        private final IProcessResponseHandler _processResponseHandler;
        private final ProcessHandler _processHandler;

        ProcessResponseHandlerThread(ProcessHandler ph) {
            this(ph, null);
        }

        ProcessResponseHandlerThread(ProcessHandler ph, IProcessResponseHandler processResponseHandler) {
            super("ProcessResponseHandler(" + ph.getDisplayName() + ")");
            this._processResponseHandler = processResponseHandler == null ? new ProcessResponseHandler(new LoggingMessageHandler(_logger, Level.DEBUG)) : processResponseHandler;
            super.setDaemon(false);
            this._processHandler = ph;
        }

        @Override
        public void run() {
            this._processResponseHandler.handleProcessResponse(this._processHandler);
        }
    }

    public static enum ProcessStatus {
        unknown,
        initialized,
        starting,
        started,
        startup_failed,
        interrupted,
        end_of_stream,
        killed,
        exitted;

    }
}

