/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.process;

import com.sybase.ua.util.process.ProcessHandler;
import com.sybase.ua.util.process.ProcessListenerAdapter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessHandlerGroup {
    private static Logger _logger = Logger.getLogger(ProcessHandlerGroup.class);
    private final List<ProcessHandler> _processGroup = new LinkedList<ProcessHandler>();
    private String _displayName;
    private boolean _killOnShutdown = false;
    private Long _delayBetweenStartup = 0L;
    private final Thread _shutdownHook = new Thread("ProcessHandlerGroupShutdownHook"){

        @Override
        public void run() {
            if (ProcessHandlerGroup.this._killOnShutdown) {
                ProcessHandlerGroup.this.killAll();
            }
        }
    };

    public ProcessHandlerGroup(String displayName) {
        this._displayName = displayName;
    }

    public void addCommand(ProcessHandler ph) {
        this._processGroup.add(ph);
    }

    public Long getDelayBetweenStartup() {
        return this._delayBetweenStartup;
    }

    public int getProcessGroupCount() {
        return this._processGroup.size();
    }

    public int getProcessGroupRunningCount() {
        int cnt = 0;
        for (ProcessHandler ph : this._processGroup) {
            if (!ph.isRunning()) continue;
            ++cnt;
        }
        return cnt;
    }

    public ProcessHandler getProcessHandler(String name) {
        for (ProcessHandler ph : this._processGroup) {
            if (!ph.getDisplayName().equalsIgnoreCase(name)) continue;
            return ph;
        }
        return null;
    }

    public List<ProcessHandler> getProcessHandlers() {
        return Collections.unmodifiableList(this._processGroup);
    }

    public boolean isKillOnShutdown() {
        return this._killOnShutdown;
    }

    public boolean isRunning() {
        return this.getProcessGroupRunningCount() > 0;
    }

    public synchronized void killAll() {
        for (ProcessHandler ph : this._processGroup) {
            ph.kill();
        }
        try {
            if (this.isKillOnShutdown()) {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void setDelayBetweenStartup(Long delayBetweenStartup) {
        this._delayBetweenStartup = delayBetweenStartup;
    }

    public void setKillOnShutdown(boolean killOnShutdown) {
        this._killOnShutdown = killOnShutdown;
    }

    public synchronized void startGroup() {
        try {
            if (!this.isRunning() && this.isKillOnShutdown()) {
                Runtime.getRuntime().addShutdownHook(this._shutdownHook);
            }
        }
        catch (IllegalArgumentException iae) {
            assert (false) : "Received IllegalArgumentException from shutdown hook indicating it's already registered.";
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        for (ProcessHandler ph : this._processGroup) {
            if (ph.isRunning()) continue;
            ph.addProcessListener(new ProcessListenerAdapter(_logger));
            ph.startProcess();
            try {
                if (this._delayBetweenStartup == null || this._delayBetweenStartup <= 0L) continue;
                Thread.sleep(this._delayBetweenStartup);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    String getDisplayName() {
        return this._displayName;
    }

    void setDisplayName(String displayName) {
        this._displayName = displayName;
    }
}

