/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.process;

import com.sybase.ua.util.process.ProcessHandler;
import com.sybase.ua.util.process.ProcessListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ProcessListenerAdapter
implements ProcessListener {
    private Logger _logger = null;
    private Level _level = null;

    public ProcessListenerAdapter() {
    }

    public ProcessListenerAdapter(Logger logger) {
        this(logger, Level.DEBUG);
    }

    public ProcessListenerAdapter(Logger logger, Level level) {
        this._logger = logger;
        this._level = level;
    }

    @Override
    public void processCompleted(ProcessHandler ph, Integer exitValue) {
        if (this._logger != null && this._level != null && this._logger.isEnabledFor((Priority)this._level)) {
            this._logger.log((Priority)this._level, (Object)("Process " + ph.getDisplayName() + " completed with exit value " + exitValue));
        }
    }

    @Override
    public void processEndOfStream(ProcessHandler ph) {
        if (this._logger != null && this._level != null && this._logger.isEnabledFor((Priority)this._level)) {
            this._logger.log((Priority)this._level, (Object)("Process " + ph.getDisplayName() + " reached the end of the process output stream"));
        }
    }

    @Override
    public void processInterrupted(ProcessHandler ph) {
        if (this._logger != null && this._level != null && this._logger.isEnabledFor((Priority)this._level)) {
            this._logger.log((Priority)this._level, (Object)("Process " + ph.getDisplayName() + " was interrupted waiting for exit."));
        }
    }

    @Override
    public void processKilled(ProcessHandler ph) {
        if (this._logger != null && this._level != null && this._logger.isEnabledFor((Priority)this._level)) {
            this._logger.log((Priority)this._level, (Object)("Process " + ph.getDisplayName() + " killed."));
        }
    }

    @Override
    public void processStarted(ProcessHandler ph) {
        if (this._logger != null && this._level != null && this._logger.isEnabledFor((Priority)this._level)) {
            this._logger.log((Priority)this._level, (Object)("Process " + ph.getDisplayName() + " started."));
        }
    }

    @Override
    public void processStarting(ProcessHandler ph) {
        if (this._logger != null && this._level != null && this._logger.isEnabledFor((Priority)this._level)) {
            this._logger.log((Priority)this._level, (Object)("Process " + ph.getDisplayName() + " is starting."));
        }
    }

    @Override
    public void processStartupFailed(ProcessHandler ph, Throwable exception) {
        if (this._logger != null && this._level != null && this._logger.isEnabledFor((Priority)this._level)) {
            this._logger.log((Priority)this._level, (Object)("Process " + ph.getDisplayName() + " failed to start: " + exception.getMessage()));
        }
    }
}

