/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.process;

import com.sybase.ua.util.process.IMessageHandler;
import com.sybase.ua.util.process.IProcessResponseHandler;
import com.sybase.ua.util.process.ProcessHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProcessResponseHandler
implements IProcessResponseHandler {
    private final Set<IMessageHandler> _messageHandlers = new LinkedHashSet<IMessageHandler>();
    private boolean _endOfStream = false;

    public ProcessResponseHandler() {
    }

    public ProcessResponseHandler(IMessageHandler ... messageHandler) {
        if (messageHandler != null) {
            this._messageHandlers.addAll(Arrays.asList(messageHandler));
        }
    }

    public void addMessageHandler(IMessageHandler ... messageHandler) {
        if (messageHandler != null) {
            this._messageHandlers.addAll(Arrays.asList(messageHandler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleProcessResponse(ProcessHandler process) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getProcessOutputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                this.handleMessage(line);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.handleEndOfStream(process);
        }
    }

    @Override
    public boolean isEndOfStream() {
        return this._endOfStream;
    }

    protected void handleEndOfStream(ProcessHandler process) {
        this._endOfStream = true;
        process.notifyProcessEndOfStream(process);
    }

    protected void handleMessage(String line) {
        for (IMessageHandler messageHandler : this._messageHandlers) {
            try {
                messageHandler.handleMessage(line);
            }
            catch (Exception e) {
                System.err.println("Failed to write to process message handler: " + line + "; Message:" + e.getMessage());
            }
        }
    }
}

