/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.process;

import com.sybase.ua.util.process.IMessageHandler;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WriterMessageHandler
implements IMessageHandler {
    private PrintWriter _output = null;
    private String _outputHeader = null;
    private boolean _prependTimestamp = false;
    private final SimpleDateFormat _dateFormat = new SimpleDateFormat();

    public WriterMessageHandler() {
        this(System.out);
    }

    public WriterMessageHandler(OutputStream os) {
        this(os, null, false);
    }

    public WriterMessageHandler(OutputStream os, String outputHeader, boolean prependTimestamp) {
        this(new PrintWriter(os), outputHeader, prependTimestamp);
    }

    public WriterMessageHandler(Writer w) {
        this(w, null, false);
    }

    public WriterMessageHandler(Writer w, String outputHeader, boolean prependTimestamp) {
        this._output = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
        this._outputHeader = outputHeader;
        this._prependTimestamp = prependTimestamp;
    }

    @Override
    public void handleMessage(String message) {
        this.writeLine(this._output, message);
    }

    protected void writeLine(PrintWriter wr, String line) {
        this.writeLine(wr, this._outputHeader, line);
    }

    protected void writeLine(PrintWriter wr, String header, String line) {
        if (wr == null) {
            return;
        }
        if (this._prependTimestamp) {
            wr.write(this._dateFormat.format(new Date()));
            wr.write(32);
        }
        if (header != null) {
            wr.write(header);
            wr.write(32);
        }
        wr.write(line);
        wr.println();
        wr.flush();
    }
}

