/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.system;

import com.sybase.ua.util.BinaryUnits;

public abstract class OperatingSystemInfo {
    private final String name;
    private final String arch;
    private final String version;
    private final int availableProcessors;
    private final double systemLoadAverage;
    private final long freePhysicalMemory;
    private final long totalPhysicalMemory;
    private final long processCpuTime;

    public OperatingSystemInfo(String name, String arch, String version, int availableProcessors, double systemLoadAverage, long freePhysicalMemorySize, long totalPhysicalMemorySize, long processCpuTime) {
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.availableProcessors = availableProcessors;
        this.systemLoadAverage = systemLoadAverage;
        this.processCpuTime = processCpuTime;
        this.freePhysicalMemory = freePhysicalMemorySize;
        this.totalPhysicalMemory = totalPhysicalMemorySize;
    }

    public String getArch() {
        return this.arch;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public long getFreePhysicalMemory() {
        return this.freePhysicalMemory;
    }

    public String getName() {
        return this.name;
    }

    public long getProcessCpuTime() {
        return this.processCpuTime;
    }

    public double getSystemLoadAverage() {
        return this.systemLoadAverage;
    }

    public long getTotalPhysicalMemory() {
        return this.totalPhysicalMemory;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format("%s [name=%s, arch=%s, version=%s, availableProcessors=%s, systemLoadAverage=%s, totalPhysicalMemorySize=%s(%sM), freePhysicalMemorySize=%s(%sM), processCpuTime=%s]", this.getClass().getSimpleName(), this.name, this.arch, this.version, this.availableProcessors, this.systemLoadAverage, this.totalPhysicalMemory, BinaryUnits.BYTES.toMega(this.totalPhysicalMemory), this.freePhysicalMemory, BinaryUnits.BYTES.toMega(this.freePhysicalMemory), this.processCpuTime);
    }

    public String format(String sep) {
        return this.getClass().getSimpleName() + "[" + sep + "name=" + this.name + sep + "arch=" + this.arch + sep + "version=" + this.version + sep + "availableProcessors=" + this.availableProcessors + sep + "systemLoadAverage=" + this.systemLoadAverage + sep + "totalPhysicalMemory=" + this.totalPhysicalMemory + "(" + BinaryUnits.BYTES.toMega(this.totalPhysicalMemory) + "M)" + sep + "freePhysicalMemory=" + this.freePhysicalMemory + "(" + BinaryUnits.BYTES.toMega(this.freePhysicalMemory) + "M)" + sep + "processCpuTime=" + this.processCpuTime + "]";
    }
}

