/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.system;

import com.sybase.ua.util.system.IBMJREOperatingSystemInfo;
import com.sybase.ua.util.system.OperatingSystemInfo;
import com.sybase.ua.util.system.SunJREOperatingSystemInfo;
import com.sybase.ua.util.system.SunJREUnixOperatingSystemInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.Comparator;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class OperatingSystemInfoFactory {
    static final RuntimeMXBean RUNTIME_MXBEAN_INSTANCE = ManagementFactory.getRuntimeMXBean();
    static final OperatingSystemMXBean OS_MXBEAN_INSTANCE = ManagementFactory.getOperatingSystemMXBean();
    static final ObjectName OS_MXBEAN_OBJECT_NAME = OperatingSystemInfoFactory.getOSObjectName();
    static final MBeanInfo OS_MXBEAN_INFO = OperatingSystemInfoFactory.getOSMBeanInfo();
    static final MBeanAttributeInfo[] OS_MXBEAN_ATTRIBUTE_INFO = OperatingSystemInfoFactory.getOSMBeanAttributeInfo();

    public static final void main(String[] args) throws Exception {
        System.out.println(OperatingSystemInfoFactory.createOperatingSystemInfo());
    }

    public static OperatingSystemInfo createOperatingSystemInfo() {
        if (OS_MXBEAN_INSTANCE.getClass().getName().startsWith("com.sun.management")) {
            if (OS_MXBEAN_INSTANCE.getClass().getName().contains("com.sun.management.UnixOperatingSystem")) {
                return OperatingSystemInfoFactory.createSunJREUnixOperatingSystemInfo();
            }
            return OperatingSystemInfoFactory.createSunJREOperatingSystemInfo();
        }
        if (OS_MXBEAN_INSTANCE.getClass().getName().startsWith("com.ibm.lang.management")) {
            return OperatingSystemInfoFactory.createIBMJREOperatingSystemInfo();
        }
        throw new IllegalStateException("Failed to get OperatingSystemInfo.  Unsupported JVM " + RUNTIME_MXBEAN_INSTANCE.getVmName() + ":" + RUNTIME_MXBEAN_INSTANCE.getVmVendor() + ":" + RUNTIME_MXBEAN_INSTANCE.getVmVersion());
    }

    static SunJREOperatingSystemInfo createSunJREOperatingSystemInfo() {
        return new SunJREOperatingSystemInfo((String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Name"), (String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Arch"), (String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Version"), (Integer)OperatingSystemInfoFactory.getOSMBeanAttributeValue("AvailableProcessors"), (Double)OperatingSystemInfoFactory.getOSMBeanAttributeValue("SystemLoadAverage"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("FreePhysicalMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("TotalPhysicalMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("CommittedVirtualMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("FreeSwapSpaceSize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("TotalSwapSpaceSize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("ProcessCpuTime"));
    }

    static SunJREUnixOperatingSystemInfo createSunJREUnixOperatingSystemInfo() {
        return new SunJREUnixOperatingSystemInfo((String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Name"), (String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Arch"), (String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Version"), (Integer)OperatingSystemInfoFactory.getOSMBeanAttributeValue("AvailableProcessors"), (Double)OperatingSystemInfoFactory.getOSMBeanAttributeValue("SystemLoadAverage"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("FreePhysicalMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("TotalPhysicalMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("CommittedVirtualMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("FreeSwapSpaceSize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("TotalSwapSpaceSize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("OpenFileDescriptorCount"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("MaxFileDescriptorCount"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("ProcessCpuTime"));
    }

    static IBMJREOperatingSystemInfo createIBMJREOperatingSystemInfo() {
        return new IBMJREOperatingSystemInfo((String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Name"), (String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Arch"), (String)OperatingSystemInfoFactory.getOSMBeanAttributeValue("Version"), (Integer)OperatingSystemInfoFactory.getOSMBeanAttributeValue("AvailableProcessors"), (Double)OperatingSystemInfoFactory.getOSMBeanAttributeValue("SystemLoadAverage"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("FreePhysicalMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("TotalPhysicalMemory"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("ProcessPhysicalMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("ProcessPrivateMemorySize"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("ProcessVirtualMemorySize"), (Integer)OperatingSystemInfoFactory.getOSMBeanAttributeValue("ProcessingCapacity"), (Long)OperatingSystemInfoFactory.getOSMBeanAttributeValue("ProcessCpuTime"));
    }

    static final ObjectName getOSObjectName() {
        try {
            return new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Required platform mbean name not valid java.lang:type=OperatingSystem", e);
        }
    }

    static final MBeanInfo getPlatformMBeanInfo(String objectName) {
        try {
            return ManagementFactory.getPlatformMBeanServer().getMBeanInfo(new ObjectName(objectName));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to query MBeanInfo for the platform " + objectName + " MBean.  Make sure it is a platform MBean defined in the platform MBean server.", e);
        }
    }

    static final MBeanInfo getOSMBeanInfo() {
        return OperatingSystemInfoFactory.getPlatformMBeanInfo("java.lang:type=OperatingSystem");
    }

    static final MBeanAttributeInfo[] getOSMBeanAttributeInfo() {
        MBeanAttributeInfo[] mbaia = OperatingSystemInfoFactory.getOSMBeanInfo().getAttributes();
        Arrays.sort(mbaia, new Comparator<MBeanAttributeInfo>(){

            @Override
            public int compare(MBeanAttributeInfo o1, MBeanAttributeInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return mbaia;
    }

    static final <T> T getOSMBeanAttributeValue(String name) {
        try {
            return (T)ManagementFactory.getPlatformMBeanServer().getAttribute(OS_MXBEAN_OBJECT_NAME, name);
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("Code requested generic type does not match the attribute '" + name + "' type.", ce);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeAttributeNotFoundException("Code requested an attribute (" + name + ") that does not exist in the " + OS_MXBEAN_OBJECT_NAME.getCanonicalName() + " mbean.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static class RuntimeAttributeNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 2358543173671274L;

        public RuntimeAttributeNotFoundException(String message, AttributeNotFoundException cause) {
            super(message, cause);
        }
    }
}

