/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.xmlmessage;

import com.sybase.ua.util.jdom.JDomUtil;
import com.sybase.ua.util.xmlmessage.XMLMessageConstants;
import com.sybase.ua.util.xmlmessage.XMLMessageInterface;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLMessage
implements XMLMessageInterface,
XMLMessageConstants {
    private static Log log = LogFactory.getLog(XMLMessage.class);
    private static final String version = "2.0";
    private Element rootElement = new Element("xmlmessage");
    private static long messageId = 1L;
    private long messageSequence = 0L;
    private String messageSource = "XMLMessage";

    public XMLMessage(String messageSource) {
        this.messageSource = messageSource;
        this.rootElement = new Element("xmlmessage");
        Element versionElement = new Element("ver");
        versionElement.setText(version);
        this.rootElement.addContent((Content)versionElement);
        this.getNextId();
        Element messageIdElement = new Element("mid");
        messageIdElement.setText(String.valueOf(messageId));
        this.rootElement.addContent((Content)messageIdElement);
    }

    @Override
    public void addMessage(int messageType, String message, String resourceKey, String[] arguments) {
        Element contentEntryElement = new Element("entry");
        Element dateTimeStampElement = new Element("dt");
        Date timestamp = Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
        dateTimeStampElement.setText(DateFormat.getInstance().format(timestamp));
        contentEntryElement.addContent((Content)dateTimeStampElement);
        Element sourceApplicationElement = new Element("src");
        sourceApplicationElement.setText(this.messageSource);
        contentEntryElement.addContent((Content)sourceApplicationElement);
        ++this.messageSequence;
        Element sequenceElement = new Element("seq");
        sequenceElement.setText(String.valueOf(this.messageSequence));
        contentEntryElement.addContent((Content)sequenceElement);
        Element messageElement = new Element("typ");
        messageElement.setText(Integer.toString(messageType));
        contentEntryElement.addContent((Content)messageElement);
        if (message != null && !message.equals("")) {
            Element localizedElement = new Element("msg");
            localizedElement.setText(message);
            contentEntryElement.addContent((Content)localizedElement);
        }
        if (resourceKey != null) {
            Element resourceKeyElement = new Element("key");
            resourceKeyElement.setText(resourceKey);
            contentEntryElement.addContent((Content)resourceKeyElement);
        }
        if (arguments != null) {
            Element argumentsElement = new Element("args");
            for (int ndx = 0; ndx < arguments.length; ++ndx) {
                Element argumentElement = new Element("arg");
                argumentElement.setAttribute("index", Integer.toString(ndx));
                argumentElement.setText(arguments[ndx]);
                argumentsElement.addContent((Content)argumentElement);
            }
            contentEntryElement.addContent((Content)argumentsElement);
        }
        this.rootElement.addContent((Content)contentEntryElement);
    }

    @Override
    public void decodeMessages(String xmlString) throws Exception {
        log.debug((Object)xmlString);
        Document xmlDocument = JDomUtil.getDocument(xmlString);
        this.rootElement = xmlDocument.getRootElement();
    }

    @Override
    public String encodeMessages() throws Exception {
        String xmlString = null;
        if (this.rootElement != null) {
            xmlString = JDomUtil.toString(this.rootElement);
        }
        return xmlString;
    }

    @Override
    public Object[] getMessageEntries() throws Exception {
        List entryList = this.rootElement.getChildren("entry");
        Object[] messageList = new Object[entryList.size()];
        for (int ndx = 0; ndx < entryList.size(); ++ndx) {
            String message;
            Element messageEntryElement = (Element)entryList.get(ndx);
            Element argumentsElement = messageEntryElement.getChild("args");
            List argumentsList = argumentsElement.getChildren("arg");
            Object[] arguments = null;
            arguments = new Object[argumentsList.size() + 6];
            String sequence = messageEntryElement.getChild("seq").getText();
            arguments[0] = sequence;
            String timestamp = messageEntryElement.getChild("dt").getText();
            arguments[1] = timestamp;
            String source = messageEntryElement.getChild("src").getText();
            arguments[2] = source;
            String type = messageEntryElement.getChild("typ").getText();
            arguments[3] = type;
            arguments[4] = "";
            Element messageMessage = messageEntryElement.getChild("msg");
            if (messageMessage != null && (message = messageMessage.getText()) != null) {
                arguments[4] = message;
            }
            String resourceKey = messageEntryElement.getChild("key").getText();
            arguments[5] = resourceKey;
            for (int ndx4 = 0; ndx4 < argumentsList.size(); ++ndx4) {
                Element argumentElement = (Element)argumentsList.get(ndx4);
                arguments[ndx4 + 6] = argumentElement.getText();
                log.debug((Object)("Argument: " + ndx4 + " is " + arguments[ndx4 + 6]));
            }
            messageList[ndx] = arguments;
        }
        return messageList;
    }

    @Override
    public long getMessageId() {
        return messageId;
    }

    @Override
    public String[] getMessages() throws Exception {
        Object[] entries = this.getMessageEntries();
        String[] messages = new String[entries.length];
        for (int ndx = 0; ndx < entries.length; ++ndx) {
            Object[] arguments = (Object[])entries[ndx];
            messages[ndx] = (String)arguments[4];
        }
        return messages;
    }

    @Override
    public String[] getMessages(ResourceBundle res) throws Exception {
        Object[] entries = this.getMessageEntries();
        String[] messages = new String[entries.length];
        for (int ndx = 0; ndx < entries.length; ++ndx) {
            Object[] arguments = (Object[])entries[ndx];
            String resourceString = res.getString((String)arguments[5]);
            MessageFormat messageFormat = new MessageFormat(resourceString);
            messages[ndx] = messageFormat.format(arguments);
        }
        return messages;
    }

    private synchronized long getNextId() {
        messageId = messageId == Long.MAX_VALUE ? Long.MIN_VALUE : ++messageId;
        return messageId;
    }
}

