<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="node">Emit</xsl:variable>

  <!-- This variable is set from Java Tree, to false for leaf elements -->
  <xsl:variable name="showSubTreeStatistics">true</xsl:variable>

  <xsl:variable name="root" select="*"/>
  <xsl:variable name="sql">SQL</xsl:variable>

  <xsl:variable name="estRC" select='format-number($root/est/rowCnt, "#.##")'/>
  <xsl:variable name="actRC" select='format-number($root/act/rowCnt, "#.##")'/>
  <xsl:variable name="estPIO" select='format-number($root/est/pio, "#.##")'/>
  <xsl:variable name="actPIO" select='format-number($root/act/pio, "#.##")'/>
  <xsl:variable name="estLIO" select='format-number($root/est/lio, "#.##")'/>
  <xsl:variable name="actLIO" select='format-number($root/act/lio, "#.##")'/>
  <xsl:variable name="estRS" select='format-number($root/est/rowSz, "#.##")'/>
  <xsl:variable name="actRS" select='format-number($root/act/rowSz, "#.##")'/>
  
  <xsl:variable name="estRCs" select='format-number((sum($root//est/rowCnt)-$estRC), "#.##")'/>
  <xsl:variable name="actRCs" select='format-number((sum($root//act/rowCnt)-$actRC), "#.##")'/>
  <xsl:variable name="estPIOs" select='format-number((sum($root//est/pio)-$estPIO), "#.##")'/>
  <xsl:variable name="actPIOs" select='format-number((sum($root//act/pio)-$actPIO), "#.##")'/>
  <xsl:variable name="estLIOs" select='format-number((sum($root//est/lio)-$estLIO), "#.##")'/>
  <xsl:variable name="actLIOs" select='format-number((sum($root//act/lio)-$actLIO), "#.##")'/>
  <xsl:variable name="estRSs" select='format-number((sum($root//est/rowSz)-$estRS), "#.##")'/>
  <xsl:variable name="actRSs" select='format-number((sum($root//act/rowSz)-$actRS), "#.##")'/>


  <xsl:template match="/">
    <html>
    <body>
      <h2>Node Statistics For 
        <xsl:choose>
          <xsl:when test="starts-with($node,'TableScan')">
            TableScan<font color="blue"><strong><xsl:value-of select="substring-after($node, 'TableScan')"/></strong></font>
          </xsl:when>
          <xsl:when test="starts-with($node,'IndexScan')">
            IndexScan<font color="green"><strong><xsl:value-of select="substring-after($node, 'IndexScan')"/></strong></font>
          </xsl:when>
          <xsl:otherwise>
            <font color="black"><strong><xsl:value-of select="$node"/></strong></font>
          </xsl:otherwise>
        </xsl:choose>
        
      </h2>

      <table width="100%">
        <tr bgcolor="#000099">
          <th align="left"><font color="#ffffff">Statistics</font></th>
          <th align="left"><font color="#ffffff">Actual</font></th>
          <th align="left"><font color="#ffffff">Estimated</font></th>
          <th align="left"><font color="#ffffff">Description</font></th>
        </tr>

        <xsl:if test="string($estRC) != 'NaN'">
          <tr bgcolor="#efefef">
            <td>Row Count</td>
            <td><strong><xsl:copy-of select="translate(string($actRC),'NaN',' -')"/></strong></td>
            <td><strong><xsl:copy-of select="$estRC"/></strong></td>
            <td>Number of rows returned</td>
          </tr>
        </xsl:if>

        <xsl:if test="string($actLIO) != 'NaN'">
          <tr bgcolor="#e8e8ff">
            <td>Logical I/O</td>
            <td><strong><xsl:copy-of select="$actLIO"/></strong></td>
            <td><strong>-</strong></td>
            <td>Logical read/write</td>
          </tr>
        </xsl:if>

        <xsl:if test="string($actPIO) != 'NaN'">
          <tr bgcolor="#efefef">
            <td>Physical I/O</td>
            <td><strong><xsl:copy-of select="$actPIO"/></strong></td>
            <td><strong>-</strong></td>
            <td>Physical read/write</td>
          </tr>
        </xsl:if>

        <xsl:if test="string($estRS) != 'NaN'">
          <tr bgcolor="#e8e8ff">
            <td>Row Size</td>
            <td><strong><xsl:copy-of select="translate(string($actRS),'NaN',' -')"/></strong></td>
            <td><strong><xsl:copy-of select="$estRS"/></strong></td>
            <td>Size of rows</td>
          </tr>
        </xsl:if>

      </table>
      

      <xsl:if test="$showSubTreeStatistics = 'true'">
        <h2>Subtree Statistics</h2>
        <table width="100%">
          <tr bgcolor="#000099">
            <th align="left"><font color="#ffffff">Statistics</font></th>
            <th align="left"><font color="#ffffff">Actual</font></th>
            <th align="left"><font color="#ffffff">Estimated</font></th>
            <th align="left"><font color="#ffffff">Description</font></th>
          </tr>

          <xsl:if test="string($estRCs) != 'NaN'">
            <tr bgcolor="#efefef">
              <td>Row Count</td>
            <td><strong><xsl:copy-of select="translate(string($actRCs),'NaN',' -')"/></strong></td>
              <td><strong><xsl:copy-of select="$estRCs"/></strong></td>
              <td>Number of rows returned</td>
            </tr>
          </xsl:if>

          <xsl:if test="string($actLIOs) != 'NaN'">
            <tr bgcolor="#e8e8ff">
              <td>Logical I/O</td>
              <td><strong><xsl:copy-of select="$actLIOs"/></strong></td>
              <td>-</td>
              <td>Logical read/write</td>
            </tr>
          </xsl:if>

          <xsl:if test="string($actPIOs) != 'NaN'">
            <tr bgcolor="#efefef">
              <td>Physical I/O</td>
              <td><strong><xsl:copy-of select="$actPIOs"/></strong></td>
              <td>-</td>
              <td>Physical read/write</td>
            </tr>
          </xsl:if>

          <xsl:if test="string($estRSs) != 'NaN'">
            <tr bgcolor="#e8e8ff">
              <td>Row Size</td>
              <td><strong><xsl:copy-of select="translate(string($actRSs),'NaN',' -')"/></strong></td>
              <td><strong><xsl:copy-of select="$estRSs"/></strong></td>
              <td>Size of rows</td>
            </tr>
          </xsl:if>

        </table>
      </xsl:if>

      <xsl:if test="string-length($root[indId | scanType | producerThreads |
                                        updateMode])
                     &gt; 0">
        <h2>Details</h2>
        <table width="100%">
          <tr bgcolor="#000099">
            <th align="left"><font color="#ffffff">Property</font></th>
            <th align="left"><font color="#ffffff">Value</font></th>
            <th align="left"><font color="#ffffff">Description</font></th>
          </tr>
          <xsl:if test="string-length($root/indId) &gt; 0">
            <tr bgcolor="#efefef">
              <td>Index ID</td>
              <td><strong><xsl:value-of select="$root/indId"/></strong></td>
              <td>ID of the index</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/indName) &gt; 0">
            <tr bgcolor="#e8e8ff">
              <td>Index Name</td>
              <td><strong><xsl:value-of select="$root/indName"/></strong></td>
              <td>Name of the index</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/corrName) &gt; 0">
            <tr bgcolor="#efefef">
              <td>Correlation Name</td>
              <td><strong><xsl:value-of select="$root/corrName"/></strong></td>
              <td>Correlation name of the object</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/scanType) &gt; 0">
            <tr bgcolor="#e8e8ff">
              <td>Scan Type</td>
              <td><strong><xsl:value-of select="$root/scanType"/></strong></td>
              <td>Type of Scan</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/scanOrder) &gt; 0">
            <tr bgcolor="#efefef">
              <td>Scan Order</td>
              <td><strong><xsl:value-of select="$root/scanOrder"/></strong></td>
              <td>Order in which scanning is done</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/scanCoverage) &gt; 0">
            <tr bgcolor="#e8e8ff">
              <td>Scan Coverage</td>
              <td>
                  <strong><xsl:value-of select="$root/scanCoverage"/></strong>
              </td>
              <td>Coverage of the Scan</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/positioning) &gt; 0">
            <tr bgcolor="#efefef">
              <td>Positioning</td>
              <td>
                  <strong><xsl:value-of select="$root/positioning"/></strong>
                  <xsl:for-each select="$root/perKey">
                    [<xsl:value-of select="keyCol"/>-
                    <xsl:value-of select="keyOrder"/>]
                  </xsl:for-each>
              </td>
              <td>Positioning of the scan</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/indexIOSizeInKB) &gt; 0">
            <tr bgcolor="#e8e8ff">
              <td>Index IO Size</td>
              <td>
                 <strong><xsl:value-of select="$root/indexIOSizeInKB"/></strong>
              </td>
              <td>Index IO size in KB</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/indexBufReplStrategy) &gt; 0">
            <tr bgcolor="#efefef">
              <td>Index Buffer Replacement Strategy</td>
              <td>
                  <strong>
                          <xsl:value-of select="$root/indexBufReplStrategy"/>
                  </strong>
              </td>
              <td>Buffer Replacement Strategy in use by the index</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/dataIOSizeInKB) &gt; 0">
            <tr bgcolor="#e8e8ff">
              <td>Data IO Size</td>
              <td>
                  <strong><xsl:value-of select="$root/dataIOSizeInKB"/></strong>
              </td>
              <td>Data IO size in KB</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/dataBufReplStrategy) &gt; 0">
            <tr bgcolor="#efefef">
              <td>Data Buffer Replacement Strategy</td>
              <td>
                  <strong>
                          <xsl:value-of select="$root/dataBufReplStrategy"/>
                  </strong>
              </td>
              <td>Buffer Replacement Strategy in use for data</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/producerThreads) &gt; 0">
            <tr bgcolor="#efefef">
              <td>Producer Threads</td>
              <td>
                 <strong><xsl:value-of select="$root/producerThreads"/></strong>
              </td>
              <td>Number of producer threads</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/consumerThreads) &gt; 0">
            <tr bgcolor="#e8e8ff">
              <td>Consumer Threads</td>
              <td>
                 <strong><xsl:value-of select="$root/consumerThreads"/></strong>
              </td>
              <td>Number of consumer threads</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/objName) &gt; 0">
            <tr bgcolor="#efefef">
              <td>Object Name</td>
              <td><strong><xsl:value-of select="$root/objName"/></strong></td>
              <td>Name of the object</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/updateMode) &gt; 0">
            <tr bgcolor="#e8e8ff">
             <td>Update Mode</td>
             <td><strong><xsl:value-of select="$root/updateMode"/></strong></td>
             <td>Mode of updation</td>
            </tr>
          </xsl:if>
        </table>
      </xsl:if>

      <xsl:if test="string-length($root/partitionInfo[partitionCount | 
                                                  eliminatedPartition]) &gt; 0">
        <h2>Partition Information</h2>
        <table width="100%">
          <tr bgcolor="#000099">
            <th align="left"><font color="#ffffff">Property</font></th>
            <th align="left"><font color="#ffffff">Value</font></th>
            <th align="left"><font color="#ffffff">Description</font></th>
          </tr>
          <xsl:if test="string-length($root/partitionInfo/partitionCount) 
                                                                        &gt; 0">
            <tr bgcolor="#efefef">
              <td>Partition Count</td>
              <td><strong><xsl:value-of 
                     select="$root/partitionInfo/partitionCount"/></strong></td>
              <td>Number of partitions</td>
            </tr>
          </xsl:if>
          <xsl:if test="string-length($root/partitionInfo/eliminatedPartition) 
                                                                        &gt; 0">
            <tr bgcolor="#e8e8ff">
              <td>Eliminated Partition</td>
              <td>
                <xsl:for-each select="$root/partitionInfo/eliminatedPartition">
                   [<xsl:value-of select="."/>]
                </xsl:for-each>
              </td>
              <td>Partitions that are eliminated</td>
            </tr>
          </xsl:if>
        </table>
      </xsl:if>

    </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
