<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" cdata-section-elements="DEF"/>
	
	<!-- variable that contains our styling for the HTML -->
	<xsl:variable name="htmlCSS">
	
	
&lt;link rel=stylesheet type="text/css" href="details.css">


&lt;!--[if IE]>
&lt;style type="text/css">
div#buffer {
  padding-top:0px;
}
&lt;/style>
&lt;![endif]-->
&lt;!--[if gte IE 5.5]>
&lt;![if lt IE 7]>
&lt;style type="text/css">
div#nsr {
  left: expression( ( ( ignoreMe2 = document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft ) ) + 'px' );
  top: expression( ( ( ignoreMe = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop ) ) + 'px' );
}
&lt;/style>
&lt;![endif]>
&lt;![endif]-->
	</xsl:variable>
	
	<!-- main body -->
	<xsl:template match="/">
		<SQLDOC>
		<xsl:apply-templates/>
		</SQLDOC>
	</xsl:template>
	
	<!-- we don't need DBN chew it up -->
	<xsl:template match="/SQLDOC/DBN"/>
	<!-- we don't want people seeing the localize element -->
	<xsl:template match="/SQLDOC/LOCALIZE"/>
	
	<!-- procedures -->
	<xsl:template match="/SQLDOC/PROCEDURES">
		<PROCEDURES>
		<xsl:for-each select="PROCEDURE">
			
			<!-- variables for each procedure -->
			
			<!-- the name of the procedure -->
			<xsl:variable name="procName" select="NAME"/>
			
			<!-- the procedure's creator / owner -->
			<xsl:variable name="procOwner" select="SCHEMA"/>
			
			<!-- the procedure's filename -->
			<xsl:variable name="procFilename" select="FILENAME"/>
			
			<!-- the list of procedures that call this procedure -->
			<xsl:variable name="usages" 
				select="/SQLDOC/PROCEDURES/PROCEDURE[REFERENCES/REFERENCE/NAME=$procName and REFERENCES/REFERENCE/SCHEMA=$procOwner]"/>
			<xsl:variable name="triggerUsages" 
				select="/SQLDOC/TRIGGERS/TRIGGER[REFERENCES/REFERENCE/NAME=$procName and REFERENCES/REFERENCE/SCHEMA=$procOwner]"/>
			<xsl:variable name="eventUsages"
				select="/SQLDOC/EVENTS/EVENT[REFERENCES/REFERENCE/NAME=$procName and REFERENCES/REFERENCE/SCHEMA=$procOwner]"/>
			
			<PROCEDURE>
			<NAME><xsl:value-of select="$procName"/></NAME>
			<SCHEMA><xsl:value-of select="$procOwner"/></SCHEMA>
			<FILENAME><xsl:value-of select="$procFilename"/></FILENAME>
			<DEF>
			&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
			&lt;html>
			&lt;head>
				&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
				&lt;title><xsl:value-of select="/SQLDOC/DBN"/> - <xsl:value-of select="$procOwner"/>.<xsl:value-of select="$procName"/>&lt;/title>
				<xsl:value-of select="$htmlCSS"/>
			&lt;/head>
			&lt;body>
		
			&lt;div id="nsr">
			&lt;h3>&#160;&#160;<xsl:value-of select="$procOwner"/>.<xsl:value-of select="$procName"/>&lt;/h3>
			&lt;/div>
			
			&lt;br/>&lt;br/>
			&lt;div id="buffer"/>
			
			&lt;dl>
			<!-- now do fun stuff with the comment -->
			<xsl:if test="COMMENT">	
				<xsl:if test="COMMENT/TEXT">
					&lt;dd class="noLeft"><xsl:value-of select="COMMENT/TEXT"/>&lt;/dd>&lt;p/>
				</xsl:if>
				<xsl:if test="COMMENT/TAGS">
					&lt;dd class="noLeft">&lt;dl>
						<xsl:for-each select="COMMENT/TAGS/TAG">
							&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
							&lt;dd><xsl:value-of select="VALUE"/>&lt;/dd>
						</xsl:for-each>
					&lt;/dl>&lt;/dd>
				</xsl:if>
			</xsl:if>
			
			<!-- now grab any updates, inserts, deletes, etc. -->
			<xsl:if test="CHANGES">
				&lt;dd class="noLeft">&lt;dl>
				<xsl:for-each select="CHANGES/*">
					<xsl:choose>
						<xsl:when test="name()='RAISERRORS'">
							<xsl:if test="count(CODE) &gt; 0">
								&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
								&lt;dd>
								<xsl:for-each select="CODE">
									<xsl:value-of select="text()"/>&#160;
								</xsl:for-each>
								&lt;/dd>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="count(TABLE) &gt; 0">
								&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
								&lt;dd>
								<xsl:for-each select="TABLE">
									&lt;code><xsl:value-of select="text()"/>&lt;/code>&#160;
								</xsl:for-each>
								&lt;/dd>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				&lt;/dl>&lt;/dd>
			</xsl:if>
			
			<!-- now see if anyone references us -->
			<xsl:if test="count($usages) &gt; 0 or count($triggerUsages) &gt; 0 or count($eventUsages) &gt; 0">
				&lt;dd class="noLeft">&lt;dl>
					&lt;dt>&lt;b><xsl:value-of select="/SQLDOC/LOCALIZE/USAGES"/>&lt;/b>&lt;/dt>
					&lt;dd>
					<xsl:for-each select="$usages">
						&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
					</xsl:for-each>
					<xsl:for-each select="$triggerUsages">
						&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.tr.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
					</xsl:for-each>
					<xsl:for-each select="$eventUsages">
						&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.ev.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
					</xsl:for-each>
					&lt;/dd>
				&lt;/dl>&lt;/dd>
			</xsl:if>
			
			<!-- now get our references -->
			<xsl:if test="REFERENCES">
				&lt;dd class="noLeft">&lt;dl>
					&lt;dt>&lt;b><xsl:value-of select="/SQLDOC/LOCALIZE/HEADING"/>&lt;/b>&lt;/dt>
					&lt;dd>
					<xsl:for-each select="REFERENCES/REFERENCE">
						<xsl:variable name="refName" select="NAME"/>
						<xsl:variable name="refSchema" select="SCHEMA"/>
						<xsl:choose>
							<xsl:when test="count(/SQLDOC/PROCEDURES/PROCEDURE[NAME=$refName and SCHEMA=$refSchema]) &gt; 0">
								&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
							</xsl:when>
							<xsl:when test="SCHEMA='evtOwner' and count(/SQLDOC/EVENTS/EVENT[NAME=$refName]) &gt; 0">
								<xsl:variable name="tempEvt" select="/SQLDOC/EVENTS/EVENT[NAME=$refName]"/>
								&lt;code>&lt;a target='detail' href='<xsl:value-of select="$tempEvt/SCHEMA"/>.<xsl:value-of select="NAME"/>.ev.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
							</xsl:when>
							<xsl:otherwise>
								&lt;code><xsl:value-of select="NAME"/>&lt;/code>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					&lt;/dd>
				&lt;/dl>&lt;/dd>
			</xsl:if>
			
			&lt;/dl> <!-- end of the definition list started above COMMENT -->
			
			<!-- add the source of the procedure -->
			<xsl:if test="DEF">
				&lt;h4><xsl:value-of select="/SQLDOC/LOCALIZE/SOURCE"/>&lt;/h4>
				&lt;pre><xsl:value-of select="DEF"/>&lt;/pre>
			</xsl:if>
			&lt;/body>&lt;/html>
			</DEF>
			</PROCEDURE>
		</xsl:for-each>
		</PROCEDURES>
	</xsl:template>
	
	<!-- triggers -->
	<xsl:template match="/SQLDOC/TRIGGERS">
		<TRIGGERS>
		<xsl:for-each select="TRIGGER">
			
			<!-- variables for each trigger -->
			
			<!-- the name of the trigger -->
			<xsl:variable name="triggerName" select="NAME"/>
			
			<!-- the trigger's creator / owner -->
			<xsl:variable name="triggerOwner" select="SCHEMA"/>
			
			<TRIGGER>
			<NAME><xsl:value-of select="$triggerName"/></NAME>
			<SCHEMA><xsl:value-of select="$triggerOwner"/></SCHEMA>
			<DEF>
			&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
			&lt;html>
			&lt;head>
				&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
				&lt;title><xsl:value-of select="/SQLDOC/DBN"/> - <xsl:value-of select="$triggerOwner"/>.<xsl:value-of select="$triggerName"/>&lt;/title>
				<xsl:value-of select="$htmlCSS"/>
			&lt;/head>
			&lt;body>
		
			&lt;div id="nsr">
			&lt;h3>&#160;&#160;<xsl:value-of select="$triggerOwner"/>.<xsl:value-of select="$triggerName"/>&lt;/h3>
			&lt;/div>
			
			&lt;br/>&lt;br/>
			&lt;div id="buffer"/>
			
			&lt;dl>
			<!-- now do fun stuff with the comment -->
			<xsl:if test="COMMENT">	
				<xsl:if test="COMMENT/TEXT">
					&lt;dd class="noLeft"><xsl:value-of select="COMMENT/TEXT"/>&lt;/dd>&lt;p/>
				</xsl:if>
				<xsl:if test="COMMENT/TAGS">
					&lt;dd class="noLeft">&lt;dl>
						<xsl:for-each select="COMMENT/TAGS/TAG">
							&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
							&lt;dd><xsl:value-of select="VALUE"/>&lt;/dd>
						</xsl:for-each>
					&lt;/dl>&lt;/dd>
				</xsl:if>
			</xsl:if>
			
			<!-- now grab any updates, inserts, deletes, etc. -->
			<xsl:if test="CHANGES">
				&lt;dd class="noLeft">&lt;dl>
				<xsl:for-each select="CHANGES/*">
					<xsl:choose>
						<xsl:when test="name()='RAISERRORS'">
							<xsl:if test="count(CODE) &gt; 0">
								&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
								&lt;dd>
								<xsl:for-each select="CODE">
									<xsl:value-of select="text()"/>&#160;
								</xsl:for-each>
								&lt;/dd>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="count(TABLE) &gt; 0">
								&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
								&lt;dd>
								<xsl:for-each select="TABLE">
									&lt;code><xsl:value-of select="text()"/>&lt;/code>&#160;
								</xsl:for-each>
								&lt;/dd>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				&lt;/dl>&lt;/dd>
			</xsl:if>
			
			<!-- now get our references -->
			<xsl:if test="REFERENCES">
				&lt;dd class="noLeft">&lt;dl>
					&lt;dt>&lt;b><xsl:value-of select="/SQLDOC/LOCALIZE/TRREFS"/>&lt;/b>&lt;/dt>
					&lt;dd>
					<xsl:for-each select="REFERENCES/REFERENCE">
						<xsl:variable name="refName" select="NAME"/>
						<xsl:variable name="refSchema" select="SCHEMA"/>
						<xsl:choose>
							<xsl:when test="count(/SQLDOC/PROCEDURES/PROCEDURE[NAME=$refName and SCHEMA=$refSchema]) &gt; 0">
								&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
							</xsl:when>
							<xsl:when test="SCHEMA='evtOwner' and count(/SQLDOC/EVENTS/EVENT[NAME=$refName]) &gt; 0">
								<xsl:variable name="tempEvt" select="/SQLDOC/EVENTS/EVENT[NAME=$refName]"/>
								&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.ev.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
							</xsl:when>
							<xsl:otherwise>
								&lt;code><xsl:value-of select="NAME"/>&lt;/code>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					&lt;/dd>
				&lt;/dl>&lt;/dd>
			</xsl:if>
			
			&lt;/dl> <!-- end of the definition list started above COMMENT -->
			
			<!-- add the source of the trigger -->
			<xsl:if test="DEF">
				&lt;h4><xsl:value-of select="/SQLDOC/LOCALIZE/SOURCE"/>&lt;/h4>
				&lt;pre><xsl:value-of select="DEF"/>&lt;/pre>
			</xsl:if>
			&lt;/body>&lt;/html>
			</DEF>
			</TRIGGER>
		</xsl:for-each>
		</TRIGGERS>
	</xsl:template>
	
	<!-- events -->
	<xsl:template match="/SQLDOC/EVENTS">
		<EVENTS>
		<xsl:for-each select="EVENT">
			
			<!-- variables for each event -->
			
			<!-- the name of the event -->
			<xsl:variable name="eventName" select="NAME"/>
			
			<!-- the event's creator / owner -->
			<xsl:variable name="eventOwner" select="SCHEMA"/>
			
			<!-- the list of everything that triggers this event. 
			     Note that we have to look for a special schema as
			     the syntax for "calling" an event is a little weird -->
			<xsl:variable name="usages" 
				select="/SQLDOC/PROCEDURES/PROCEDURE[REFERENCES/REFERENCE/NAME=$eventName and REFERENCES/REFERENCE/SCHEMA='evtOwner']"/>
			<xsl:variable name="triggerUsages" 
				select="/SQLDOC/TRIGGERS/TRIGGER[REFERENCES/REFERENCE/NAME=$eventName and REFERENCES/REFERENCE/SCHEMA='evtOwner']"/>
			<xsl:variable name="eventUsages"
				select="/SQLDOC/EVENTS/EVENT[REFERENCES/REFERENCE/NAME=$eventName and REFERENCES/REFERENCE/SCHEMA='evtOwner']"/>
			
			<EVENT>
			<NAME><xsl:value-of select="$eventName"/></NAME>
			<SCHEMA><xsl:value-of select="$eventOwner"/></SCHEMA>
			<DEF>
			&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
			&lt;html>
			&lt;head>
				&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
				&lt;title><xsl:value-of select="/SQLDOC/DBN"/> - <xsl:value-of select="$eventOwner"/>.<xsl:value-of select="$eventName"/>&lt;/title>
				<xsl:value-of select="$htmlCSS"/>
			&lt;/head>
			&lt;body>
		
			&lt;div id="nsr">
			&lt;h3>&#160;&#160;<xsl:value-of select="$eventOwner"/>.<xsl:value-of select="$eventName"/>&lt;/h3>
			&lt;/div>
			
			&lt;br/>&lt;br/>
			&lt;div id="buffer"/>
			
			&lt;dl>
			<!-- now do fun stuff with the comment -->
			<xsl:if test="COMMENT">	
				<xsl:if test="COMMENT/TEXT">
					&lt;dd class="noLeft"><xsl:value-of select="COMMENT/TEXT"/>&lt;/dd>&lt;p/>
				</xsl:if>
				<xsl:if test="COMMENT/TAGS">
					&lt;dd class="noLeft">&lt;dl>
						<xsl:for-each select="COMMENT/TAGS/TAG">
							&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
							&lt;dd><xsl:value-of select="VALUE"/>&lt;/dd>
						</xsl:for-each>
					&lt;/dl>&lt;/dd>
				</xsl:if>
			</xsl:if>
			
			<!-- now grab any updates, inserts, deletes, etc. -->
			<xsl:if test="CHANGES">
				&lt;dd class="noLeft">&lt;dl>
				<xsl:for-each select="CHANGES/*">
					<xsl:choose>
						<xsl:when test="name()='RAISERRORS'">
							<xsl:if test="count(CODE) &gt; 0">
								&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
								&lt;dd>
								<xsl:for-each select="CODE">
									<xsl:value-of select="text()"/>&#160;
								</xsl:for-each>
								&lt;/dd>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="count(TABLE) &gt; 0">
								&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
								&lt;dd>
								<xsl:for-each select="TABLE">
									&lt;code><xsl:value-of select="text()"/>&lt;/code>&#160;
								</xsl:for-each>
								&lt;/dd>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				&lt;/dl>&lt;/dd>
			</xsl:if>
			
			<!-- now see if anyone references us -->
			<xsl:if test="count($usages) &gt; 0 or count($triggerUsages) &gt; 0 or count($eventUsages) &gt; 0">
				&lt;dd class="noLeft">&lt;dl>
					&lt;dt>&lt;b><xsl:value-of select="/SQLDOC/LOCALIZE/EVUSAGES"/>&lt;/b>&lt;/dt>
					&lt;dd>
					<xsl:for-each select="$usages">
						&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
					</xsl:for-each>
					<xsl:for-each select="$triggerUsages">
						&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.tr.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
					</xsl:for-each>
					<xsl:for-each select="$eventUsages">
						&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.ev.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
					</xsl:for-each>
					&lt;/dd>
				&lt;/dl>&lt;/dd>
			</xsl:if>
			
			<!-- now get our references -->
			<xsl:if test="REFERENCES">
				&lt;dd class="noLeft">&lt;dl>
					&lt;dt>&lt;b><xsl:value-of select="/SQLDOC/LOCALIZE/EVREFS"/>&lt;/b>&lt;/dt>
					&lt;dd>
					<xsl:for-each select="REFERENCES/REFERENCE">
						<xsl:variable name="refName" select="NAME"/>
						<xsl:variable name="refSchema" select="SCHEMA"/>
						<xsl:choose>
							<xsl:when test="count(/SQLDOC/PROCEDURES/PROCEDURE[NAME=$refName and SCHEMA=$refSchema]) &gt; 0">
								&lt;code>&lt;a target='detail' href='<xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/>.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
							</xsl:when>
							<xsl:when test="SCHEMA='evtOwner' and count(/SQLDOC/EVENTS/EVENT[NAME=$refName]) &gt; 0">
								<xsl:variable name="tempEvt" select="/SQLDOC/EVENTS/EVENT[NAME=$refName]"/>
								&lt;code>&lt;a target='detail' href='<xsl:value-of select="$tempEvt/SCHEMA"/>.<xsl:value-of select="NAME"/>.ev.html'><xsl:value-of select="NAME"/>&lt;/a>&lt;/code>&#160;
							</xsl:when>
							<xsl:otherwise>
								&lt;code><xsl:value-of select="NAME"/>&lt;/code>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					&lt;/dd>
				&lt;/dl>&lt;/dd>
			</xsl:if>
			
			&lt;/dl> <!-- end of the definition list started above COMMENT -->
			
			<!-- add the source of the event -->
			<xsl:if test="DEF">
				&lt;h4><xsl:value-of select="/SQLDOC/LOCALIZE/SOURCE"/>&lt;/h4>
				&lt;pre><xsl:value-of select="DEF"/>&lt;/pre>
			</xsl:if>
			&lt;/body>&lt;/html>
			</DEF>
			</EVENT>
		</xsl:for-each>
		</EVENTS>
	</xsl:template>
	
	<!-- views -->
	<xsl:template match="/SQLDOC/VIEWS">
		<VIEWS>
		<xsl:for-each select="VIEW">
			
			<!-- variables for each view -->
			
			<!-- the name of the view -->
			<xsl:variable name="viewName" select="NAME"/>
			
			<!-- the view's creator / owner -->
			<xsl:variable name="viewOwner" select="SCHEMA"/>
			
			<VIEW>
			<NAME><xsl:value-of select="$viewName"/></NAME>
			<SCHEMA><xsl:value-of select="$viewOwner"/></SCHEMA>
			<DEF>
			&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
			&lt;html>
			&lt;head>
				&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
				&lt;title><xsl:value-of select="/SQLDOC/DBN"/> - <xsl:value-of select="$viewOwner"/>.<xsl:value-of select="$viewName"/>&lt;/title>
				<xsl:value-of select="$htmlCSS"/>
			&lt;/head>
			&lt;body>
		
			&lt;div id="nsr">
			&lt;h3>&#160;&#160;<xsl:value-of select="$viewOwner"/>.<xsl:value-of select="$viewName"/>&lt;/h3>
			&lt;/div>
			
			&lt;br/>&lt;br/>
			&lt;div id="buffer"/>
			
			&lt;dl>
			<!-- now do fun stuff with the comment -->
			<xsl:if test="COMMENT">	
				<xsl:if test="COMMENT/TEXT">
					&lt;dd class="noLeft"><xsl:value-of select="COMMENT/TEXT"/>&lt;/dd>&lt;p/>
				</xsl:if>
				<xsl:if test="COMMENT/TAGS">
					&lt;dd class="noLeft">&lt;dl>
						<xsl:for-each select="COMMENT/TAGS/TAG">
							&lt;dt>&lt;b><xsl:value-of select="NAME"/>&lt;/b>&lt;/dt>
							&lt;dd><xsl:value-of select="VALUE"/>&lt;/dd>
						</xsl:for-each>
					&lt;/dl>&lt;/dd>
				</xsl:if>
			</xsl:if>
			
			&lt;/dl> <!-- end of the definition list started above COMMENT -->
			
			<!-- add the source of the view -->
			<xsl:if test="DEF">
				&lt;h4><xsl:value-of select="/SQLDOC/LOCALIZE/SOURCE"/>&lt;/h4>
				&lt;pre><xsl:value-of select="DEF"/>&lt;/pre>
			</xsl:if>
			&lt;/body>&lt;/html>
			</DEF>
			</VIEW>
		</xsl:for-each>
		</VIEWS>
	</xsl:template>
</xsl:stylesheet>
