<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" 
		omit-xml-declaration="yes" 
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" 
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" 
		indent="yes"/>
	
	<!-- main body -->
	<xsl:template match="/">
		<html>
		<head>
			<title><xsl:value-of select="/SQLDOC/DBN"/></title>
			<script type="text/javascript">
var textNode;
var procDivs;

function findY( obj )
{
	var curtop = 0;
	if( obj.offsetParent ) {
		curtop = obj.offsetTop;
		while( obj = obj.offsetParent ) {
			curtop += obj.offsetTop;
		}
	}
	return curtop;
}

function init()
{
	if( document.documentElement ) {
		document.documentElement.onscroll = function () {
			updateNSR();
		}
	}
	
	// get the text element
	if( document.getElementById ) {
		// standards-compliant browsers (e.g. firefox) use this
		textNode = document.getElementById( 'nsrText' );
	} else if( document.all ) {
		// for IE
		textNode = document.all.nsrText;
	} else if( document.layers ) {
		// for old versions of Netscape
		textNode = document.layers.nsrText;
	}
	
	procDivs = new Array();
	var idx = 0;
	for( i in document.anchors ) {
		if( document.anchors[i].id == "procAnchor" ) {
			<!-- we do this subtraction so to make things look more natural -->
			var curY = findY( document.anchors[i] ) - 25;
			procDivs[idx] = new Array( curY, document.anchors[i].name );
			idx++;
		} else if( document.anchors[i].id == "suffixAnchor" ) {
			var curY = findY( document.anchors[i] ) - 25;
			var anchorName = document.anchors[i].name.substring(0, document.anchors[i].name.length - 3);
			procDivs[idx] = new Array( curY, anchorName );
			idx++;
		}
	}
	updateNSR();
}



function updateNSR()
{
	var winY = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
	
	for( var i = 0; i &lt; procDivs.length; i++ ) {
		if( i == procDivs.length - 1 ) {
			var proc = procDivs[i];
			if( winY &gt;= proc[0] ) {
				textNode.innerHTML = '  ' +  decodeURI(proc[1]);
			}
			return;
		} else {
			var proc1 = procDivs[i];
			var proc2 = procDivs[i+1];
			if( ( winY &gt;= proc1[0] ) &#38;&#38; ( winY &lt;= proc2[0] ) ) {
				textNode.innerHTML = '  ' +  decodeURI(proc1[1]);
				return;
			}
		}
	}
}
			</script>
			
			
<link rel="stylesheet" type="text/css" href="details.css"></link>


<!-- this section is wrapped in an xsl:comment so that it gets output as a comment in the HTML
     file.  It's also wrapped in CDATA so that the stylesheet will compile -->
<xsl:comment><![CDATA[[if gte IE 5.5]>
<![if lt IE 7]>
<style type="text/css">
div#nsr {
  left: expression( ( ( ignoreMe2 = document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft ) ) + 'px' );
  top: expression( ( ( ignoreMe = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop ) ) + 'px' );
}
</style>
<![endif]>
<![endif] ]]></xsl:comment>
		</head>
		<body onscroll="updateNSR()" onmousewheel="updateNSR()" onload="init()">
			<div id="nsr">
			<h3 id="nsrText">&#160;&#160;</h3>
			</div>
			<br/>
			
			<xsl:apply-templates/>
		</body></html>
	</xsl:template>
	
	<!-- we don't need DBN chew it up -->
	<xsl:template match="/SQLDOC/DBN"/>
	<!-- we don't want people seeing the localize element -->
	<xsl:template match="/SQLDOC/LOCALIZE"/>
	
	<!-- procedures -->
	<xsl:template match="/SQLDOC/PROCEDURES">
		<xsl:for-each select="PROCEDURE">
			<xsl:sort select="SCHEMA"/>	
			<xsl:sort select="NAME"/>	
			
			<!-- variables for each procedure -->
			
			<!-- the name of the procedure -->
			<xsl:variable name="procName" select="NAME"/>
			
			<!-- the procedure's creator / owner -->
			<xsl:variable name="procOwner" select="SCHEMA"/>
			
			<!-- the list of procedures that call this procedure -->
			<xsl:variable name="usages" 
				select="/SQLDOC/PROCEDURES/PROCEDURE[REFERENCES/REFERENCE/NAME=$procName and REFERENCES/REFERENCE/SCHEMA=$procOwner]"/>
			
			<xsl:variable name="triggerUsages" 
				select="/SQLDOC/TRIGGERS/TRIGGER[REFERENCES/REFERENCE/NAME=$procName and REFERENCES/REFERENCE/SCHEMA=$procOwner]"/>
			
			<xsl:variable name="eventUsages"
				select="/SQLDOC/EVENTS/EVENT[REFERENCES/REFERENCE/NAME=$procName and REFERENCES/REFERENCE/SCHEMA=$procOwner]"/>
				
			<h3>
			<a name='{$procOwner}.{$procName}' id="procAnchor">
			<xsl:value-of select="$procOwner"/>.<xsl:value-of select="$procName"/></a></h3>
	
			<dl>
			<!-- now do fun stuff with the comment -->
			<xsl:if test="COMMENT">	
				<xsl:if test="COMMENT/TEXT">
					<dd class="noLeft"><xsl:value-of select="COMMENT/TEXT" disable-output-escaping="yes"/></dd><p/>
				</xsl:if>
				<xsl:if test="COMMENT/TAGS">
					<dd class="noLeft"><dl>
						<xsl:for-each select="COMMENT/TAGS/TAG">
							<dt><b><xsl:value-of select="NAME"/></b></dt>
							<dd><xsl:value-of select="VALUE" disable-output-escaping="yes"/></dd>
						</xsl:for-each>
					</dl></dd>
				</xsl:if>
			</xsl:if>
			
			<!-- now grab any updates, inserts, deletes, etc. -->
			<xsl:if test="CHANGES">
				<dd class="noLeft"><dl>
				<xsl:for-each select="CHANGES/*">
					<xsl:choose>
						<xsl:when test="name()='RAISERRORS'">
							<xsl:if test="count(CODE) &gt; 0">
								<dt><b><xsl:value-of select="NAME"/></b></dt>
								<dd>
								<xsl:for-each select="CODE">
									<xsl:value-of select="text()"/>&#160;
								</xsl:for-each>
								</dd>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="count(TABLE) &gt; 0">
								<dt><b><xsl:value-of select="NAME"/></b></dt>
								<dd>
								<xsl:for-each select="TABLE">
									<code><xsl:value-of select="text()"/></code>&#160;
								</xsl:for-each>
								</dd>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				</dl></dd>
			</xsl:if>
			
			<!-- now see if anyone references us -->
			<xsl:if test="count($usages) &gt; 0 or count($triggerUsages) &gt; 0 or count($eventUsages) &gt; 0">
				<dd class="noLeft"><dl>
					<dt><b><xsl:value-of select="/SQLDOC/LOCALIZE/USAGES"/></b></dt>
					<dd>
					<xsl:for-each select="$usages">
						<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}'><xsl:value-of select="NAME"/></a></code>&#160;
					</xsl:for-each>
					<xsl:for-each select="$triggerUsages">
						<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}.tr'><xsl:value-of select="NAME"/></a></code>&#160;
					</xsl:for-each>
					<xsl:for-each select="$eventUsages">
						<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}.ev'><xsl:value-of select="NAME"/></a></code>&#160;
					</xsl:for-each>
					</dd>
				</dl></dd>
			</xsl:if>
			
			<!-- now get our references -->
			<xsl:if test="REFERENCES">
				<dd class="noLeft"><dl>
					<dt><b><xsl:value-of select="/SQLDOC/LOCALIZE/HEADING"/></b></dt>
					<dd>
					<xsl:for-each select="REFERENCES/REFERENCE">
						<xsl:variable name="refName" select="NAME"/>
						<xsl:variable name="refSchema" select="SCHEMA"/>
						<xsl:choose>
							<xsl:when test="count(/SQLDOC/PROCEDURES/PROCEDURE[NAME=$refName and SCHEMA=$refSchema]) &gt; 0">
								<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}'><xsl:value-of select="NAME"/></a></code>&#160;
							</xsl:when>
							<xsl:when test="SCHEMA='evtOwner' and count(/SQLDOC/EVENTS/EVENT[NAME=$refName]) &gt; 0">
								<xsl:variable name="tempEvt" select="/SQLDOC/EVENTS/EVENT[NAME=$refName]"/>
								<code><a target='detail' href='detail.html#{$tempEvt/SCHEMA}.{NAME}.ev'><xsl:value-of select="NAME"/></a></code>&#160;
							</xsl:when>
							<xsl:otherwise>
								<code><xsl:value-of select="NAME"/></code>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					</dd>
				</dl></dd>
			</xsl:if>
			
			</dl> <!-- end of the definition list started above COMMENT -->
			
			<!-- add the source of the procedure -->
			<xsl:if test="DEF">
				<h4><xsl:value-of select="/SQLDOC/LOCALIZE/SOURCE"/></h4>
				<pre><xsl:value-of select="DEF" disable-output-escaping="yes"/></pre>
			</xsl:if>
			
			<!-- put a horizontal line after each procedure -->
			<hr/>
		</xsl:for-each>
	</xsl:template>
	
	<!-- triggers -->
	<xsl:template match="/SQLDOC/TRIGGERS">
		<xsl:for-each select="TRIGGER">
			<xsl:sort select="SCHEMA"/>	
			<xsl:sort select="NAME"/>	
			
			<h3><a name='{SCHEMA}.{NAME}.tr' id="suffixAnchor"><xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/></a></h3>
	
			<dl>
			<!-- now do fun stuff with the comment -->
			<xsl:if test="COMMENT">	
				<xsl:if test="COMMENT/TEXT">
					<dd class="noLeft"><xsl:value-of select="COMMENT/TEXT" disable-output-escaping="yes"/></dd><p/>
				</xsl:if>
				<xsl:if test="COMMENT/TAGS">
					<dd class="noLeft"><dl>
						<xsl:for-each select="COMMENT/TAGS/TAG">
							<dt><b><xsl:value-of select="NAME"/></b></dt>
							<dd><xsl:value-of select="VALUE" disable-output-escaping="yes"/></dd>
						</xsl:for-each>
					</dl></dd>
				</xsl:if>
			</xsl:if>
			
			<!-- now grab any updates, inserts, deletes, etc. -->
			<xsl:if test="CHANGES">
				<dd class="noLeft"><dl>
				<xsl:for-each select="CHANGES/*">
					<xsl:choose>
						<xsl:when test="name()='RAISERRORS'">
							<xsl:if test="count(CODE) &gt; 0">
								<dt><b><xsl:value-of select="NAME"/></b></dt>
								<dd>
								<xsl:for-each select="CODE">
									<xsl:value-of select="text()"/>&#160;
								</xsl:for-each>
								</dd>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="count(TABLE) &gt; 0">
								<dt><b><xsl:value-of select="NAME"/></b></dt>
								<dd>
								<xsl:for-each select="TABLE">
									<code><xsl:value-of select="text()"/></code>&#160;
								</xsl:for-each>
								</dd>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				</dl></dd>
			</xsl:if>
			
			<!-- now get our references -->
			<xsl:if test="REFERENCES">
				<dd class="noLeft"><dl>
					<dt><b><xsl:value-of select="/SQLDOC/LOCALIZE/TRREFS"/></b></dt>
					<dd>
					<xsl:for-each select="REFERENCES/REFERENCE">
						<xsl:variable name="refName" select="NAME"/>
						<xsl:variable name="refSchema" select="SCHEMA"/>
						<xsl:choose>
							<xsl:when test="count(/SQLDOC/PROCEDURES/PROCEDURE[NAME=$refName and SCHEMA=$refSchema]) &gt; 0">
								<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}'><xsl:value-of select="NAME"/></a></code>&#160;
							</xsl:when>
							<xsl:when test="SCHEMA='evtOwner' and count(/SQLDOC/EVENTS/EVENT[NAME=$refName]) &gt; 0">
								<xsl:variable name="tempEvt" select="/SQLDOC/EVENTS/EVENT[NAME=$refName]"/>
								<code><a target='detail' href='detail.html#{$tempEvt/SCHEMA}.{NAME}.ev'><xsl:value-of select="NAME"/></a></code>&#160;
							</xsl:when>
							<xsl:otherwise>
								<code><xsl:value-of select="NAME"/></code>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					</dd>
				</dl></dd>
			</xsl:if>
			
			</dl> <!-- end of the definition list started above COMMENT -->
			
			<!-- add the source of the trigger -->
			<xsl:if test="DEF">
				<h4><xsl:value-of select="/SQLDOC/LOCALIZE/SOURCE"/></h4>
				<pre><xsl:value-of select="DEF" disable-output-escaping="yes"/></pre>
			</xsl:if>
			
			<!-- put a horizontal line after each trigger -->
			<hr/>
		</xsl:for-each>
	</xsl:template>
	
	<!-- events -->
	<xsl:template match="/SQLDOC/EVENTS">
		<xsl:for-each select="EVENT">
			<xsl:sort select="SCHEMA"/>	
			<xsl:sort select="NAME"/>	
		
			<!-- variables for each event -->
			
			<!-- the name of the event -->
			<xsl:variable name="eventName" select="NAME"/>
		
			<!-- the list of everything that triggers this event. 
			     Note that we have to look for a special schema as
			     the syntax for "calling" an event is a little weird -->
			<xsl:variable name="usages" 
				select="/SQLDOC/PROCEDURES/PROCEDURE[REFERENCES/REFERENCE/NAME=$eventName and REFERENCES/REFERENCE/SCHEMA='evtOwner']"/>
			
			<xsl:variable name="triggerUsages" 
				select="/SQLDOC/TRIGGERS/TRIGGER[REFERENCES/REFERENCE/NAME=$eventName and REFERENCES/REFERENCE/SCHEMA='evtOwner']"/>
			
			<xsl:variable name="eventUsages"
				select="/SQLDOC/EVENTS/EVENT[REFERENCES/REFERENCE/NAME=$eventName and REFERENCES/REFERENCE/SCHEMA='evtOwner']"/>
			
			<h3><a name='{SCHEMA}.{NAME}.ev' id="suffixAnchor"><xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/></a></h3>
	
			<dl>
			<!-- now do fun stuff with the comment -->
			<xsl:if test="COMMENT">	
				<xsl:if test="COMMENT/TEXT">
					<dd class="noLeft"><xsl:value-of select="COMMENT/TEXT" disable-output-escaping="yes"/></dd><p/>
				</xsl:if>
				<xsl:if test="COMMENT/TAGS">
					<dd class="noLeft"><dl>
						<xsl:for-each select="COMMENT/TAGS/TAG">
							<dt><b><xsl:value-of select="NAME"/></b></dt>
							<dd><xsl:value-of select="VALUE" disable-output-escaping="yes"/></dd>
						</xsl:for-each>
					</dl></dd>
				</xsl:if>
			</xsl:if>
			
			<!-- now grab any updates, inserts, deletes, etc. -->
			<xsl:if test="CHANGES">
				<dd class="noLeft"><dl>
				<xsl:for-each select="CHANGES/*">
					<xsl:choose>
						<xsl:when test="name()='RAISERRORS'">
							<xsl:if test="count(CODE) &gt; 0">
								<dt><b><xsl:value-of select="NAME"/></b></dt>
								<dd>
								<xsl:for-each select="CODE">
									<xsl:value-of select="text()"/>&#160;
								</xsl:for-each>
								</dd>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="count(TABLE) &gt; 0">
								<dt><b><xsl:value-of select="NAME"/></b></dt>
								<dd>
								<xsl:for-each select="TABLE">
									<code><xsl:value-of select="text()"/></code>&#160;
								</xsl:for-each>
								</dd>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				</dl></dd>
			</xsl:if>
			
			<!-- now see if anyone references us -->
			<xsl:if test="count($usages) &gt; 0 or count($triggerUsages) &gt; 0 or count($eventUsages) &gt; 0">
				<dd class="noLeft"><dl>
					<dt><b><xsl:value-of select="/SQLDOC/LOCALIZE/EVUSAGES"/></b></dt>
					<dd>
					<xsl:for-each select="$usages">
						<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}'><xsl:value-of select="NAME"/></a></code>&#160;
					</xsl:for-each>
					<xsl:for-each select="$triggerUsages">
						<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}.tr'><xsl:value-of select="NAME"/></a></code>&#160;
					</xsl:for-each>
					<xsl:for-each select="$eventUsages">
						<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}.ev'><xsl:value-of select="NAME"/></a></code>&#160;
					</xsl:for-each>
					</dd>
				</dl></dd>
			</xsl:if>
			
			<!-- now get our references -->
			<xsl:if test="REFERENCES">
				<dd class="noLeft"><dl>
					<dt><b><xsl:value-of select="/SQLDOC/LOCALIZE/EVREFS"/></b></dt>
					<dd>
					<xsl:for-each select="REFERENCES/REFERENCE">
						<xsl:variable name="refName" select="NAME"/>
						<xsl:variable name="refSchema" select="SCHEMA"/>
						<xsl:choose>
							<xsl:when test="count(/SQLDOC/PROCEDURES/PROCEDURE[NAME=$refName and SCHEMA=$refSchema]) &gt; 0">
								<code><a target='detail' href='detail.html#{SCHEMA}.{NAME}'><xsl:value-of select="NAME"/></a></code>&#160;
							</xsl:when>
							<xsl:when test="SCHEMA='evtOwner' and count(/SQLDOC/EVENTS/EVENT[NAME=$refName]) &gt; 0">
								<xsl:variable name="tempEvt" select="/SQLDOC/EVENTS/EVENT[NAME=$refName]"/>
								<code><a target='detail' href='detail.html#{$tempEvt/SCHEMA}.{NAME}.ev'><xsl:value-of select="NAME"/></a></code>&#160;
							</xsl:when>
							<xsl:otherwise>
								<code><xsl:value-of select="NAME"/></code>&#160;
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					</dd>
				</dl></dd>
			</xsl:if>
			
			</dl> <!-- end of the definition list started above COMMENT -->
			
			<!-- add the source of the event -->
			<xsl:if test="DEF">
				<h4><xsl:value-of select="/SQLDOC/LOCALIZE/SOURCE"/></h4>
				<pre><xsl:value-of select="DEF" disable-output-escaping="yes"/></pre>
			</xsl:if>
			
			<!-- put a horizontal line after each event -->
			<hr/>
		</xsl:for-each>
	</xsl:template>
	
	<!-- views -->
	<xsl:template match="/SQLDOC/VIEWS">
		<xsl:for-each select="VIEW">
			<xsl:sort select="SCHEMA"/>	
			<xsl:sort select="NAME"/>	
			
			<h3><a name='{SCHEMA}.{NAME}.vi' id="suffixAnchor"><xsl:value-of select="SCHEMA"/>.<xsl:value-of select="NAME"/></a></h3>
	
			<dl>
			<!-- now do fun stuff with the comment -->
			<xsl:if test="COMMENT">	
				<xsl:if test="COMMENT/TEXT">
					<dd class="noLeft"><xsl:value-of select="COMMENT/TEXT" disable-output-escaping="yes"/></dd><p/>
				</xsl:if>
				<xsl:if test="COMMENT/TAGS">
					<dd class="noLeft"><dl>
						<xsl:for-each select="COMMENT/TAGS/TAG">
							<dt><b><xsl:value-of select="NAME"/></b></dt>
							<dd><xsl:value-of select="VALUE" disable-output-escaping="yes"/></dd>
						</xsl:for-each>
					</dl></dd>
				</xsl:if>
			</xsl:if>
			
			</dl> <!-- end of the definition list started above COMMENT -->
			
			<!-- add the source of the view -->
			<xsl:if test="DEF">
				<h4><xsl:value-of select="/SQLDOC/LOCALIZE/SOURCE"/></h4>
				<pre><xsl:value-of select="DEF" disable-output-escaping="yes"/></pre>
			</xsl:if>
			
			<!-- put a horizontal line after each view -->
			<hr/>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
