<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" 
		omit-xml-declaration="yes" 
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" 
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" 
		indent="yes"/>
	
	<xsl:template match="/">
	<html>
	<head>
	<style type="text/css">
	a {
		color:#193989;
		text-decoration:none;
	}
	</style>
	</head>
	<body>
		<xsl:if test="count(/SQLDOC/PROCEDURES/PROCEDURE) &gt; 0">
		<h3><xsl:value-of select="/SQLDOC/LOCALIZE/HEADING"/></h3>
		<table border="0" width="100%" summary="">
		<tr><td>
		<xsl:for-each select="SQLDOC/PROCEDURES/PROCEDURE">
			<xsl:sort select="NAME"/>	
			<a target='detail' href='{FILENAME}'><xsl:value-of select="NAME"/></a><br/>
		</xsl:for-each>
		</td></tr>
		</table>
		</xsl:if>
		
		<xsl:if test="count(/SQLDOC/TRIGGERS/TRIGGER) &gt; 0">
		<h3><xsl:value-of select="/SQLDOC/LOCALIZE/TRHEADING"/></h3>
		<table border="0" width="100%" summary="">
		<tr><td>
		<xsl:for-each select="SQLDOC/TRIGGERS/TRIGGER">
			<xsl:sort select="NAME"/>	
			<a target='detail' href='{FILENAME}'><xsl:value-of select="NAME"/></a><br/>
		</xsl:for-each>
		</td></tr>
		</table>
		</xsl:if>
		
		<xsl:if test="count(/SQLDOC/EVENTS/EVENT) &gt; 0">		
		<h3><xsl:value-of select="/SQLDOC/LOCALIZE/EVHEADING"/></h3>
		<table border="0" width="100%" summary="">
		<tr><td>
		<xsl:for-each select="SQLDOC/EVENTS/EVENT">
			<xsl:sort select="NAME"/>	
			<a target='detail' href='{FILENAME}'><xsl:value-of select="NAME"/></a><br/>
		</xsl:for-each>
		</td></tr>
		</table>
		</xsl:if>
		
		<xsl:if test="count(/SQLDOC/VIEWS/VIEW) &gt; 0">
		<h3><xsl:value-of select="/SQLDOC/LOCALIZE/VIHEADING"/></h3>
		<table border="0" width="100%" summary="">
		<tr><td>
		<xsl:for-each select="SQLDOC/VIEWS/VIEW">
			<xsl:sort select="NAME"/>	
			<a target='detail' href='{FILENAME}'><xsl:value-of select="NAME"/></a><br/>
		</xsl:for-each>
		</td></tr>
		</table>
		</xsl:if>
	</body></html>
	</xsl:template>
	
</xsl:stylesheet>
