<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" 
		omit-xml-declaration="yes" 
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" 
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" 
		indent="yes"/>
	
	<!-- this key allows for us to group procedures by owner -->
	<xsl:key name="procs-by-owner" match="SQLDOC/PROCEDURES/PROCEDURE" use="SCHEMA"/>
	<!-- and another for triggers -->
	<xsl:key name="triggers-by-owner" match="SQLDOC/TRIGGERS/TRIGGER" use="SCHEMA"/>
	<!-- for events -->
	<xsl:key name="events-by-owner" match="SQLDOC/EVENTS/EVENT" use="SCHEMA"/>
	<!-- for views -->
	<xsl:key name="views-by-owner" match="SQLDOC/VIEWS/VIEW" use="SCHEMA"/>
	
	<xsl:template match="/">
	<html>
	<head>
		<title><xsl:value-of select="/SQLDOC/DBN"/></title>
<script type="text/javascript">
function expandHandler( layer, tree )
{
	var style2;
	var imgElem;
	
	if( document.getElementById ) {
		// standards-compliant browsers (e.g. firefox) use this
		style2 = document.getElementById( layer ).style;
		imgElem = document.getElementById( tree );
	} else if( document.all ) {
		// for IE
		style2 = document.all.layer.style;
		imgElem = document.all.tree;
	} else if( document.layers ) {
		// for old versions of Netscape
		style2 = document.layers.layer.style;
		imgElem = document.layers.tree;
	}
	
	if( style2.display == "none" ) {
		style2.display = "block";
		imgElem.src = "collapse.png";
	} else {
		style2.display = "none";
		imgElem.src = "expand.png";
	}
}
</script>
<style type="text/css">
a.ownerHeading {
	color:#193989;
	font-weight:bold;
	text-decoration:none;
}

img.tree {
	cursor:pointer;
}
</style>
	</head>
	<body>
		<xsl:if test="count(/SQLDOC/PROCEDURES/PROCEDURE) &gt; 0">
		<h3><xsl:value-of select="/SQLDOC/LOCALIZE/HEADING"/></h3>
		<!-- unfortunately Java currently doesn't support XSLT 2.0 so we can't use
		     the nice for-each-group, instead we have to use the Muenchian Method -->
		<xsl:for-each select="SQLDOC/PROCEDURES/PROCEDURE[generate-id()=generate-id(key('procs-by-owner', SCHEMA)[1])]">
			<xsl:sort select="SCHEMA"/>
			
			<xsl:variable name="currSchema" select="SCHEMA"/>
			<img src="expand.png" onClick="expandHandler('{$currSchema}procs', '{$currSchema}Tree')" class="tree" id="{$currSchema}Tree"/>
			<a href="javascript://" onClick="expandHandler('{$currSchema}procs', '{$currSchema}Tree')" class='ownerHeading'>
				&#160;<xsl:value-of select="$currSchema"/>
			</a>
			<div id="{$currSchema}procs" style="display:none;">
			<table>
			<tr><td>
			<xsl:for-each select="key('procs-by-owner', SCHEMA)">
				<xsl:sort select="NAME"/>
				<xsl:variable name="filename" select="FILENAME"/>
				&#160;&#160;&#160;&#160;<a target='detail' href='{$filename}'><xsl:value-of select="NAME"/></a><br/>
			</xsl:for-each>
			</td></tr>
			</table>
			</div>
			<br/>
		</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="count(/SQLDOC/TRIGGERS/TRIGGER) &gt; 0">	
		<h3><xsl:value-of select="/SQLDOC/LOCALIZE/TRHEADING"/></h3>
		<!-- unfortunately Java currently doesn't support XSLT 2.0 so we can't use
		     the nice for-each-group, instead we have to use the Muenchian Method -->
		<xsl:for-each select="SQLDOC/TRIGGERS/TRIGGER[generate-id()=generate-id(key('triggers-by-owner', SCHEMA)[1])]">
			<xsl:sort select="SCHEMA"/>
			
			<xsl:variable name="currSchema" select="SCHEMA"/>
			<img src="expand.png" onClick="expandHandler('{$currSchema}triggers', '{$currSchema}TreeTr')" class="tree" id="{$currSchema}TreeTr"/>
			<a href="javascript://" onClick="expandHandler('{$currSchema}triggers', '{$currSchema}TreeTr')" class='ownerHeading'>
				&#160;<xsl:value-of select="$currSchema"/>
			</a>
			<div id="{$currSchema}triggers" style="display:none;">
			<table>
			<tr><td>
			<xsl:for-each select="key('triggers-by-owner', SCHEMA)">
				<xsl:sort select="NAME"/>
				<xsl:variable name="filename" select="FILENAME"/>
				&#160;&#160;&#160;&#160;<a target='detail' href='{$filename}'><xsl:value-of select="NAME"/></a><br/>
			</xsl:for-each>
			</td></tr>
			</table>
			</div>
			<br/>
		</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="count(/SQLDOC/EVENTS/EVENT) &gt; 0">
		<h3><xsl:value-of select="/SQLDOC/LOCALIZE/EVHEADING"/></h3>
		<!-- unfortunately Java currently doesn't support XSLT 2.0 so we can't use
		     the nice for-each-group, instead we have to use the Muenchian Method -->
		<xsl:for-each select="SQLDOC/EVENTS/EVENT[generate-id()=generate-id(key('events-by-owner', SCHEMA)[1])]">
			<xsl:sort select="SCHEMA"/>
			
			<xsl:variable name="currSchema" select="SCHEMA"/>
			<img src="expand.png" onClick="expandHandler('{$currSchema}events', '{$currSchema}TreeEv')" class="tree" id="{$currSchema}TreeEv"/>
			<a href="javascript://" onClick="expandHandler('{$currSchema}events', '{$currSchema}TreeEv')" class='ownerHeading'>
				&#160;<xsl:value-of select="$currSchema"/>
			</a>
			<div id="{$currSchema}events" style="display:none;">
			<table>
			<tr><td>
			<xsl:for-each select="key('events-by-owner', SCHEMA)">
				<xsl:sort select="NAME"/>
				<xsl:variable name="filename" select="FILENAME"/>
				&#160;&#160;&#160;&#160;<a target='detail' href='{$filename}'><xsl:value-of select="NAME"/></a><br/>
			</xsl:for-each>
			</td></tr>
			</table>
			</div>
			<br/>
		</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="count(/SQLDOC/VIEWS/VIEW) &gt; 0">
		<h3><xsl:value-of select="/SQLDOC/LOCALIZE/VIHEADING"/></h3>
		<!-- unfortunately Java currently doesn't support XSLT 2.0 so we can't use
		     the nice for-each-group, instead we have to use the Muenchian Method -->
		<xsl:for-each select="SQLDOC/VIEWS/VIEW[generate-id()=generate-id(key('views-by-owner', SCHEMA)[1])]">
			<xsl:sort select="SCHEMA"/>
			
			<xsl:variable name="currSchema" select="SCHEMA"/>
			<img src="expand.png" onClick="expandHandler('{$currSchema}views', '{$currSchema}TreeVi')" class="tree" id="{$currSchema}TreeVi"/>
			<a href="javascript://" onClick="expandHandler('{$currSchema}views', '{$currSchema}TreeVi')" class='ownerHeading'>
				&#160;<xsl:value-of select="$currSchema"/>
			</a>
			<div id="{$currSchema}views" style="display:none;">
			<table>
			<tr><td>
			<xsl:for-each select="key('views-by-owner', SCHEMA)">
				<xsl:sort select="NAME"/>
				<xsl:variable name="filename" select="FILENAME"/>
				&#160;&#160;&#160;&#160;<a target='detail' href='{$filename}'><xsl:value-of select="NAME"/></a><br/>
			</xsl:for-each>
			</td></tr>
			</table>
			</div>
			<br/>
		</xsl:for-each>
		</xsl:if>
	</body></html>
	</xsl:template>
	
</xsl:stylesheet>
