@ECHO OFF

call ..\..\SYBASE.bat

if "%SYBROOT%" == "" goto no_SYBROOT

if "%SYBASE_JRE6%" == "" goto no_SYBASE_JRE6

SET ASEP_DIR=%SYBROOT%\ASEP

REM if PROCESSOR_ARCHITECTURE not "x86", assume 64-bit 
IF "%PROCESSOR_ARCHITECTURE%" == "x86" (
    IF "%PROCESSOR_ARCHITEW6432%" == "" (
        set SC_PLAT=win32) ELSE (
        set SC_PLAT=win64)
) ELSE (
    set SC_PLAT=win64)

REM use 64-bit scjview.exe only if it exists and runs on win64
set SCJVIEW=%SYBROOT%\Shared\Sybase Central 6.0.0\win32\scjview.exe
IF "%SC_PLAT%" == "win64" (
    IF EXIST "%SYBROOT%\Shared\Sybase Central 6.0.0\%SC_PLAT%\scjview.exe" (
        set SCJVIEW=%SYBROOT%\Shared\Sybase Central 6.0.0\%SC_PLAT%\scjview.exe
    )
)

if "%SYBASE_WS%" == "" set SYBASE_WS=WS-15_0

IF NOT EXIST "%ASEP_DIR%\lib\ASEPlugin.jar" goto no_aseplugin:
IF NOT EXIST "%SYBROOT%\Shared\lib\dsparser.jar" goto no_dsparser:
IF NOT EXIST "%SYBROOT%\Shared\lib\jconn4.jar" goto no_jconn:
IF NOT EXIST "%SYBROOT%\Shared\java\jsyblib600.jar" goto no_jsyblib
IF NOT EXIST "%SYBROOT%\DBISQL\lib\jlogon.jar" goto no_jlogon
IF NOT EXIST "%SYBASE_JRE6%\bin\java.exe" goto no_java:

IF "%1" == "" goto run_sybasecentral:

REM Do the one parameter options first

IF /i "%1" EQU "-h" goto show_usage:

IF /i "%1" EQU "-i" goto run_interactiveconsole:

IF /i "%1" EQU "-v" goto show_version:

IF /i "%1" == "-s" goto run_silentmode:


goto show_usage:

:run_silentmode
    IF /i "%2" EQU "" goto show_usage:
    "%SYBASE_JRE6%\bin\java" -DSYBASE_JRE6="%SYBASE_JRE6%" -DSYBASE_WS="%SYBASE_WS%" -cp "%ASEP_DIR%\lib\ASEPlugin.jar;%SYBROOT%\Shared\lib\jconn4.jar;%SYBROOT%\Shared\lib\dsparser.jar;%SYBROOT%\DBISQL\lib\jlogon.jar;%SYBROOT%\Shared\java\jsyblib600.jar" com.sybase.aseplugin.so.WebServicesConfigurationSO %*
    goto end

:run_interactiveconsole
    "%SYBASE_JRE6%\bin\java" -cp "%ASEP_DIR%\lib\ASEPlugin.jar;%SYBROOT%\Shared\lib\jconn4.jar;%SYBROOT%\Shared\lib\dsparser.jar;%SYBROOT%\DBISQL\lib\jlogon.jar;%SYBROOT%\Shared\java\jsyblib600.jar" com.sybase.aseplugin.so.WebServicesConfigurationSO %*
   goto end

:run_sybasecentral
    IF NOT EXIST "%SCJVIEW%" goto no_scjview:
    "%SCJVIEW%"
    goto end

:no_SYBASE_JRE6
    echo You need to set SYBASE_JRE6 to the directory where your Java JRE is installed.
    goto end

:no_SYBROOT
    echo You need to set SYBROOT to the directory where your Sybase Central products are installed.
    goto end

:no_scjview
    echo Unable to find the Sybase Central Binary.
    echo Please check that SYBROOT has been set correctly and 	
    echo that the file %SCJVIEW% exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:no_aseplugin
    echo Unable to find the ASE Plug-in Binary.
    echo Please check that SYBROOT has been set correctly and 	
    echo that the file %ASEP_DIR%\lib\ASEPlugin.jar exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end
    
:no_dsparser
    echo Unable to find the Directory Service Parser Binary.
    echo Please check that SYBROOT has been set correctly and 	
    echo that the file %SYBROOT%\Shared\lib\dsparser.jar exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:no_jconn
    echo Unable to find the Connectivity Libraries.
    echo Please check that SYBROOT has been set correctly and
    echo that the file %SYBROOT%\Shared\lib\jconn4.jar exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:no_jsyblib
    echo Unable to find the Sybase Central Shared Library.
    echo Please check that SYBROOT has been set correctly and
    echo that the file %SYBROOT%\Shared\java\jsyblib600.jar exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:no_jlogon
    echo Unable to find the Logon Shared Library.
    echo Please check that SYBROOT has been set correctly and
    echo that the file %SYBROOT%\DBISQL\lib\jlogon.jar exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:show_version
    "%SYBASE_JRE6%\bin\java" -jar %ASEP_DIR%\lib\ASEPlugin.jar -v
    goto end

:no_java
    echo Unable to find the Java Binary.
    echo Please check that SYBROOT has been set correctly and 	
    echo that the file %SYBASE_JRE6%\bin\java exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:show_usage

    echo Usage: aseplugin ^<options^> ^<arguments^>
    echo.
    echo options:
    echo        -h Displays this help.
    echo        -v Prints version information.
    echo        -i Run application in interactive console mode.
    echo        -s Run application in silent mode.
    echo.
    echo arguments:     [ Applicable only with -i options ]
    echo        file1   [ Location of file to output error/progress {optional} ]
    echo.
    echo arguments:     [ Applicable only with -s option ]
    echo        file1   [ Location of resource file in java properties format ]
    echo        file2   [ Location of file to output error/progress {optional} ]
    echo.
    echo.
    echo Sample usage1: [ Running ASE Plugin in normal mode ]
    echo.
    echo aseplugin 
    echo.
    echo.
    echo Sample usage2: [ Running ASE Plugin in interactive console mode ]
    echo.
    echo aseplugin -i 
    echo.
    echo.
    echo Sample usage3: [ Running ASE Plugin in silent mode ]
    echo.
    echo aseplugin -s %SYBASE%\WS-15_0\props\ws.properties %SYBASE%\WS-15_0\e.log
    goto end

:end
