@echo off

call ..\..\SYBASE.bat

if "%SYBROOT%" == "" goto no_SYBROOT

if "%SYBASE_JRE6%" == "" goto no_SYBASE_JRE
IF NOT EXIST "%SYBASE_JRE6%\bin\java.exe" goto no_java:
IF NOT EXIST "%SYBROOT%\ASEP\lib\ASEPlugin.jar" goto no_ASEPlugin:

REM if PROCESSOR_ARCHITECTURE not "x86", assume 64-bit 
IF "%PROCESSOR_ARCHITECTURE%" == "x86" (
    IF "%PROCESSOR_ARCHITEW6432%" == "" (
        set SC_PLAT=win32) ELSE (
        set SC_PLAT=win64)
) ELSE (
    set SC_PLAT=win64)

"%SYBASE_JRE6%\bin\java" -jar "%SYBROOT%\ASEP\lib\ASEPlugin.jar" -r "%SYBROOT%"

IF NOT EXIST "%SYBROOT%\ASEP\bin\ASEPlugin.jpr" goto no_ASEPlugin_jpr:

"%SYBROOT%\Shared\Sybase Central 6.0.0\%SC_PLAT%\scjview.exe" -register "%SYBROOT%\ASEP\bin\ASEPlugin.jpr"
echo ASE Plug-in registered.

"%SYBROOT%\DBISQL\bin\registerASEIP.bat"

goto end

:no_SYBASE_JRE
    echo You need to set SYBASE_JRE6 to the directory where your Java JRE is installed.
    goto end

:no_SYBROOT
    echo You need to set SYBROOT to the directory where your Sybase Central products are installed.
    goto end

:no_java
    echo Unable to find the Java Binary.
    echo Please check that SYBROOT has been set correctly and
    echo that the file %SYBASE_JRE6%\bin\java exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:no_ASEPlugin
    echo Unable to find the ASE Plug-in Binary.
    echo Please check that SYBROOT has been set correctly and
    echo that the file %SYBROOT%\ASEP\lib\ASEPlugin.jar exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:no_ASEPlugin_jpr
    echo Unable to find the ASE Plug-in Registration file.
    echo Please check that SYBROOT has been set correctly and
    echo that the file %SYBROOT%\ASEP\bin\ASEPlugin.jpr exists.
    echo SYBROOT currently set to %SYBROOT%
    goto end

:end
