' DeSpace.VBS written by Dave Wilkins 2007

' used to exchange spaces for underscores in file & folder names
' in a path starting from (but not including) the folder shown.

' Typically this would be used in Programs -Before to prepare a file
' set For backup to an FTP server (or similar) which did not support
' filesnames containing spaces. A complementary script (ReSpace.VBS)
' is supplied to revert files back to their old filenames if req'd. 
' This complementary script would be placed in Programs - After

' Note that any pre-existing underscores in filenames will be turned
' into spaces by ReSpace.VBS, if used, ie

' original: My File_Name.ext
' DeSpaced: My_File_Name.ext
' ReSpaced: My File Name.ext

RootFolder = "X:\ROOT_FOLDER"

'OR

' Set objArgs = WScript.Arguments
' RootFolder = objArgs.Item(0) 
' note that any path argument with spaces must be wrapped in " "

RootFolder = RTB(RootFolder) ' remove trailing backslash (if any)

Set FSO = CreateObject("Scripting.FileSystemObject")
Set Folders = FSO.GetFolder(RootFolder)

Recurse Folders

' < = < =< = < = end of main logioc / start of subs & functions = > = > = > = >

Sub Recurse (ByRef Folders)

  : Set SubFolders = Folders.SubFolders
   Set Files = Folders.Files
   
   For Each File In Files
       Temp = Replace(File.Name, " ", "_")
       If File.Name <> Temp Then File.Name = Temp
   Next

   For Each SubFolder In SubFolders
       Temp = Replace(SubFolder.Name, " ", "_")
       If SubFolder.Name <> Temp Then SubFolder.Name = Temp
       Recurse SubFolder
   Next

End Sub

Function RTB(sPath) ' Remove Trailing Backslash (from) Path in question

	Len_sPath = Len(sPath)
	If Right(sPath, 1) = "\" Then	
		sPath = Left(sPath, Len_sPath-1) 
	End If
	RTB = sPath

End Function
