' used in Programs - Before to check if PC is in 'home' office
' in current form, uses a config file on disk with DHCP addresses
' this should be in the form
' 10.0.0.1
' 123.124.125.126
' etcetera
' The file can contain other strings also - any that do not match
' the DHCP address supplied to the PC on arrival will be rejected 

' The config file name can be hard-coded, or supplied as a parameter, thus

ConfigName = "C:\DHCP.TXT"

'OR

'Set objArgs = WScript.Arguments
'ConfigName = objArgs.Item(0)

' actually the DHCP address itself could be hard coded if you prefer
' in which case the "Get contents of config" section can be discarded

' Get current DHCP

strComputer = "." 
strCurrentDHCP = "" 

Set objWMI = GetObject("winmgmts:\\" & strComputer & "\root\cimv2") 
Set colItems = objWMI.ExecQuery("SELECT * FROM Win32_NetworkAdapterConfiguration", , 48)

For Each objItem In colItems 
	If Not IsNull(objItem.DHCPServer) Then 
		strCurrentDHCP = objItem.DHCPServer ' have current DHCP address 
	End If 
Next 

'Get contents of config file & compare entries

Set filesys = CreateObject("Scripting.FileSystemObject") 
Set readfile = filesys.OpenTextFile(ConfigName, 1, False, False) 'Reading, NoCreate, ASCII

FoundHome = 1 ' SBSE returnvalue to stop profile

Do While Not readfile.AtEndOfStream
	Entry = readfile.ReadLine 
	If strCurrentDHCP = Entry Then
		FoundHome = 0 ' SBSE return value to let profile run go ahead
		Exit Do
	End If
Loop 

readfile.Close 

Set objWMI = Nothing: Set colItems = Nothing: Set filesys = Nothing: Set readfile = Nothing

Wscript.Quit(FoundHome) ' return a value to tell SBSE to run profile or not
