
' Subroutines to map next available drive letter to UNC path (create network drive)
' and UnMap it again after temporary use

' testing code below can be removed except recommend keep the Dim statement 
' as a "reminder" it is being used as a Public variable (sort of), not only
' to keep track of the drive letter between Subs but also for use in main logic (!)

' the Wscript.Echo commands used purely for monitoring progress can be removed, but suggest
' keep the "can't find a letter" in error-trap at end of MapNextAvailableDriveLetter sub

' Written 13 Nov 2007 by Dave Wilkins

Dim MappedDriveLetter 

MapNextAvailableDriveLetter "\\DWHOME\C$" ' substitute your own UNC path for testing

UnMapTempNetDrive


'= = = = = = = = = = END OF MAIN  LOGIC / START OF SUBS & FUNCTIONS = = = = = = =


Sub MapNextAvailableDriveLetter (UNCpath) ' OR (UNCpath, Uname, Upwd)

	Set objDict = CreateObject("Scripting.Dictionary")
	Set objWMI = GetObject("winmgmts:\\.\root\cimv2")
	Set colDisks = objWMI.ExecQuery("Select * from Win32_LogicalDisk")

	For Each objDisk in colDisks
    	objDict.Add objDisk.DeviceID, objDisk.DeviceID
	Next

	For d = 67 To 90 ' C to Z
		strDrive = Chr(d) & ":"
		If objDict.Exists(strDrive) Then
			'	do nothing
	    	Else
			Wscript.Echo "Drive " & strDrive & " is available - mapping..."
			Set TempNet = WScript.CreateObject("WScript.Network")
			TempNet.MapNetworkDrive strDrive, UNCpath, False ' OR, plus, Uname, Upwd, if used
			MappedDriveLetter = strDrive
			Wscript.Echo UNCpath & " successfully mapped to " & MappedDriveLetter
			Exit Sub
    		End If
	Next
	Wscript.Echo "There are no available drive letters on this computer": Wscript.Quit(1)

End Sub

'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Sub UnMapTempNetDrive

	Set TempNet = WScript.CreateObject("WScript.Network")
	TempNet.RemoveNetworkDrive MappedDriveLetter
	Wscript.echo "Temporary network drive " & MappedDriveLetter & " successfully disconnected"
	Set TempNet = Nothing

End Sub
