' MoveExpiredFiles by Dave Wilkins 2007

' a utility to strip out files over (as shown) 1 month old from a file-set.
' This is to cater for the fact that SyncBackSE does not (at time of writing)
' have a facility For filtering by Months, only by secs, mins, hrs & days.
' Because there are a varying number of days in a month, using (say) 30 days
' in the filter is inaccurate for more than half the year

' The script can be easily modified to handle 2 or 3 months (etc) by simply
' editing (or supplying) a different value of MonthBar

' The idea is to run this script in Programs - Before of a profile
' which uses the script's Destination as its (the profile's) Source.
' The profile will then Zip the Moved files and transfer them to the
' "real" Destination, as set in profile.
' Thus, requires the use of an interim staging-area with sufficient space

' Hard-code the Source and Dest (actually, staging-area)

SourcePath = "C:\TOPMOST FOLDER OF TARGET"
DestPath = "X:\TEMPLOC" ' staging-area                 
MonthBar = 1

' OR, 
' Set objArgs = WScript.Arguments
' SourcePath = objArgs.Item(0)
' DestPath = objArgs.Item(1)
' MonthBar = objArgs.Item(2)

SourcePath = RTB(SourcePath) ' remove trailing backslashes, if any
DestPath = RTB(DestPath) '     ditto

SourcePathLen = Len(SourcePath) 

Set FSO = CreateObject("Scripting.FileSystemObject") 
Set Folders = FSO.GetFolder(SourcePath) 

DateToday = Now() 

Recurse Folders 

' < = < = < = < = end of main logic / start of subroutines / functions = > = > = > = > 

Sub Recurse(ByRef Folders) 
  
	Set Subfolders = Folders.Subfolders 
	Set Files = Folders.Files 

	FolderNameLen = Len(Folders.Path) 
	DestFolderPath= DestPath & Right(Folders.Path, FolderNameLen - SourcePathLen) & "\" 

	For Each File In Files ' traverse every file in each (sub)folder 
		If DateDiff("m", File.DateLastModified, DateToday) > MonthBar Then 
			If Not FSO.FolderExists(DestFolderPath) Then FSO.CreateFolder DestFolderPath 
			' only create folders on Dest if there's something to put in them :-> 
			' and if it exists already (quite likely for files 2-n...), don't try and repeat
			On Error Resume Next 
			File.Move DestFolderPath
		End If 
	Next

	For Each Folder In Subfolders 
		Recurse Folder 
	Next  

	Set Subfolders = Nothing 
	Set Files = Nothing 

End Sub

Function RTB(sPath) ' Remove Trailing Backslash from path in question

	Len_sPath = Len(sPath)
	If Right(sPath, 1) = "\" Then	
		sPath = Left(sPath, Len-sPath-1) 
	End If
	RTB = sPath

End Function
