'------------------------------------------------------
' Script to remove file or folder. File or folder is
' argument 1 when calling the script.
'
' Created by Alex, based on code from timestamp.vbs as
' provided by Michael J. Leaver (www.2BrightSparks.com)
'
' Free for non-commercial use.
'
' Run by calling "cscript removeSource.vbs <arg>"
' where <arg> is full path of the to-be-removed file or
' folder.
' Files should be full filenames (path included)
' and without any wildcards.
' Folders can either end with a "\" or not.
'------------------------------------------------------


'------------------------------------------------------
'Main code
'------------------------------------------------------

Set objArgs = WScript.Arguments
Set fso = CreateObject("Scripting.FileSystemObject")

If (objArgs.Count < 1) then
WScript.Echo "No filename or dirname to remove was supplied."
Else
' Concatenate all the arguments to create on file/dirname
' This is to avoid problems with spaces in filenames or dirnames.
OldFileDirname = ""
For I = 0 To objArgs.Count - 1
OldFileDirname = OldFileDirname & objArgs.Item(I) & " "
Next
OldFileDirname = Trim(OldFileDirname)

'whether the argument represents a file or a folder, eliminate any trailing "\".
If (Right(OldFileDirname,1) = "\") Then
OldFileDirname = Left(OldFileDirname, Len(OldFileDirname) -1)
End If

Set objFileSystem = CreateObject("Scripting.FileSystemObject")

'determine whether user gave file or folder as argument
If fso.FileExists(OldFileDirname) = True Then
Set oFile = objFileSystem.GetFile(OldFileDirname)
oFile.Delete()
ElseIf fso.FolderExists(OldFileDirname) = True Then
Set oFolder = objFileSystem.GetFolder(OldFileDirname)
oFolder.Delete()
Else
WScript.Echo "File or directory <" & OldFileDirname & "> not found."
End If

End If
