'
' Scans an SBSE backup destination for Versions (contents of $SBV$ folders) and exports
' them to [elsewhere]; file/folder deletion of original $SBV$ folders is included
'
' Why are $SBV$ folders not deleted immediately after copy of all contents?
' Because the recursion logic tries (on next iteration) to check if there are
' any subfolders OF the $SBV$, which is kinda hard to do if you've just deleted it...
'
' Thus, the storage of $SBV$ deletion-candidates in array for later attack...
'
' Note that this routine will not handle UNC paths.
' It will be necessary to map a network drive to the resource, using something like

'  If Not fso.DriveExists("X:") Then
'   Set TempNet = WScript.CreateObject("WScript.Network")
'   TempNet.MapNetworkDrive "X:", "\\server\path", False, "username", "password"
' End If

' False refers to make-permanent, i.e don't (I assume if you wanted a permanent
' mapped drive, it would be in place already :->
' False is the default, so If UN & PW not required (user already logged on to 
' network and credentials are sufficient), last three parameters can be omitted.

' If the DriveExists test is used, the line
' Set fso = CreateObject("Scripting.FileSystemObject")
' will need to be placed before the drive-mapping code, or an error will occur
'
' Use TempNet.RemoveNetworkDrive "X:" at suitable point to remove it if req

' written by Dave Wilkins 12 Nov 2007
' 
' = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 

BackupRoot = "X:\TestCopy\H_VERSIONED" 
VerMoveRoot = "X:\H_VERSIONS_ONLY" 
VerFolder = "$SBV$"

' OR, 
'Set objArgs = WScript.Arguments
'BackupRoot = objArgs.Item(0)
'VerMoveRoot = objArgs.Item(1)
'VerFolder = objArgs.Item(2)

BackupRoot  = RTB(BackupRoot) '  remove trailing backslash, if any
VerMoveRoot = RTB(VerMoveRoot) ' ditto

BackupRootLen = Len(BackupRoot) ' used in Recurse sub

Set fso = CreateObject("Scripting.FileSystemObject")
Set folders = fso.GetFolder(BackupRoot)

' initialise
Pointer = 0
Dim EmptyFolderList() ' actually gives one row - will adjust later...
FoundSomeVersions = False

' go!

Recurse folders ' scan all folders in source tree

If FoundSomeVersions Then

	' note that as folder names were stored in array in ascending order of depth, we do not
	' need to sort them here. All we need do is walk backwards (upwards) through the
	' array, killing children first, parents after (!), then moving on to another "family"

	For f = Ubound(EmptyFolderList) To 1 Step -1 
		fso.DeleteFolder EmptyFolderList(f) 
		' using 1 as To in loop as EmptyFolderList(0) has a blank line in it
	Next
	WScript.Echo "Success: Version Stripping Completed": Wscript.Quit(0) ' OK
Else
	WScript.Echo "Failure(?) - found no Versions to strip...": WScript.Quit(1) ' Not OK
End If

' Quit commands (with return values above) are for use with any calling code
' (SBSE profile, maybe); delete if not required (can be left in also - no harm)


'= = = = = = = = = = END OF MAIN  LOGIC / START OF SUBS & FUNCTIONS = = = = = = = 


Sub Recurse (ByRef folders)
  
  Set subfolders = folders.Subfolders: Set files = folders.Files

FolderNameLen = Len(Folders.Path)
VerMovePath= VerMoveRoot & Right(Folders.Path, FolderNameLen - BackupRootLen) & "\"
	
  	If ImmediateParent(Folders.Path) = VerFolder Then
  		FoundSomeVersions = True
		VerMovePath = TruncatedParent(VerMovePath)
	     	CheckBuildTree(VerMovePath) ' check whether Ver Move (sub)folder exists; if not, create it
		For Each file In files ' traverse each (sub)folder
		      File.Move VerMovePath
		Next
		Pointer = Pointer + 1 ' increment...
		Redim Preserve EmptyFolderList(Pointer) ' add extra line to EmptyFolderList array
		EmptyFolderList(Pointer) = Folders.Path ' add empty $SBV$folder details to the list

	End If
	
  For Each folder In subfolders
    Recurse folder 
  Next  

  Set subfolders = Nothing: Set files = Nothing

End Sub
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Function ImmediateParent (FIQ) ' Folder In Question

	Temp = ""
	FIQ = RTB(FIQ) ' trim trailing backslash if any
	LenPath = Len(FIQ)

	For c = LenPath To 1 Step -1
		If Mid(FIQ, c, 1) <> "\" then
			Temp = Temp & Mid(FIQ, c, 1)
		Else
			Exit For
		End If
	Next
	ImmediateParent = StrReverse(Temp)
	
End Function
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Function TruncatedParent (FIQ) ' Folder In Question

	FIQ = RTB(FIQ) ' trim trailing backslash if any
	LenPath = Len(FIQ)
	
	For c = LenPath To 3 Step -1 ' must be at least a drive letter, colon & backslash
		If Mid(FIQ, c, 1) = "\" then Exit For
	Next
	If c < 3 Then Wscript.Echo "Error in TruncatedParent": WScript.Quit(1)
	' if we looped all the way thru and didn't find a \, then c will overflow (ITC, underflow!)
	TruncatedParent = Left(FIQ, c)

End Function
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Sub CheckBuildTree (FIQ) ' Folder In Question

	Temp = Left(FIQ, 3) ' prepend X:\ (or whatever)
	For c = 4 To Len(FIQ) ' skip first three chars (or it will hit first \)
		Char = Mid(FIQ, c, 1)
		Temp = Temp & Char
		If Char = "\" Then ' we have found end of a folder-level
			If Not fso.FolderExists(Temp) Then
				 fso.CreateFolder Temp
			End If
		End If
	Next

End Sub
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Function RTB(FIQ) ' Remove Trailing Backslash (from) Folder In Question

	LenFIQ = Len(FIQ)
	If Right(FIQ, 1) = "\" Then	
		FIQ = Left(FIQ, LenFIQ-1) 
	End If
	RTB = FIQ

End Function
