'------------------------------------------------------
' Add a timestamp to the start of the filename
' corresponding to the date the file was last changed.
' (Alter line starting "timestamp =" to alter the
' format of the timestamp that is prepended.)
'
' (c) J.G.Clark 23.3.2004, with Functions from
' www.paulsadowski.com/WSH.
'
' Modified by Michael J. Leaver (www.2BrightSparks.com)
' to concatenate arguments to avoid problems with
' spaces in filenames, display an error message if no
' filename was supplied, and also to copy the original
' file instead of moving it. This is to help its use
' with SyncBack (www.SyncBack.com)
'
' Free for non-commerical use.
'
' Run by calling "cscript timestamp.vbs <arg>"
' where <arg> is full path of file to filestamp.
' Works for UNC paths as well.
'------------------------------------------------------

'------------------------------------------------------
'Return the pathname portion of a full pathname
'------------------------------------------------------
Function Pathname(FullPath)
dim x, y
dim tmpstring

  x = Len(FullPath)
  for y = x to 1 step -1
    if mid(FullPath, y, 1) = "\" or _
      mid(FullPath, y, 1) = "/" then
      tmpstring = mid(Fullpath, 1, y-1)
      exit for
    end if
next
Pathname = tmpstring
end function

'------------------------------------------------------
'Return the filename portion of a full pathname
'------------------------------------------------------
Function Basename(FullPath)
dim x, y
dim tmpstring

  tmpstring = FullPath
  x = Len(FullPath)
  for y = x to 1 step -1
    if mid(FullPath, y, 1) = "\" or _
      mid(FullPath, y, 1) = ":" or _
      mid(FullPath, y, 1) = "/" then
      tmpstring = mid(Fullpath, y+1)
      exit for
    end if
  next
Basename = tmpstring
end function

'------------------------------------------------------
'Main code
'------------------------------------------------------

Set objArgs = WScript.Arguments
Set fso = CreateObject("Scripting.FileSystemObject")

if (objArgs.Count < 1) then
    WScript.Echo "No filename to copy was supplied."
else
    ' Concatenate all the arguments to create on filename
    ' This is to avoid problems with spaces in filenames.
    OldFilename = ""
    for I = 0 to objArgs.Count - 1
        OldFilename = OldFilename & objArgs.Item(I) & " "
    Next
    OldFilename = Trim(OldFilename)

    if fso.FileExists(OldFilename) = True then
      Set f = fso.GetFile(OldFilename)
      fc = f.DateLastModified
      timestamp = Year(fc) & "-" & right("00" & Month(fc), 2) & "-" & right("00" & Day(fc), 2) & space(1) & right("00" & Hour(fc), 2) & right("00" & Minute(fc), 2) & space(1)
      NewFilename = Pathname(OldFilename) & "\" & timestamp & Basename(OldFilename)
      WScript.Echo NewFilename
      fso.CopyFile OldFilename, NewFilename, True
    else
      WScript.Echo "File <" & OldFilename & "> not found"
    end if
end if

