; **************************************************************************
; === Define constants ===
; **************************************************************************
!define /date VER	"%Y.%m.%d.%H"
!define APPNAME 	"Syncovery"
!define APP 		"Syncovery"
!define APPEXE 		"Syncovery.exe"
!define APPDIR 		"App\Syncovery"

; --- Define RegKeys ---
	!define REGKEY1 "HKEY_CURRENT_USER\Software\Syncovery"
	!define REGKEY2 "HKEY_CURRENT_USER\Software\SOMUSQUE"
	!define REGKEY3 "HKEY_LOCAL_MACHINE\SOFTWARE\Syncovery"

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\${APP}Portable\${APP}Portable.exe"
Icon "${APP}.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************
Function Init
CreateDirectory "$EXEDIR\Data\${APP}\Logs"
WriteINIStr "$EXEDIR\Data\${APP}\${APP}.ini" "Main" "LogFolder" "$EXEDIR\Data\${APP}\Logs"
CreateDirectory "$EXEDIR\Data\${APP}\Database"
WriteINIStr "$EXEDIR\Data\${APP}\${APP}.ini" "Main" "DatabasePath" "$EXEDIR\Data\${APP}\Database"

WriteINIStr "$EXEDIR\Data\${APP}\${APP}.ini" "Registration" "RegNameV6" "Reverse Engineering Passion Team"
WriteINIStr "$EXEDIR\Data\${APP}\${APP}.ini" "Registration" "RegCodeV6" "1CIFAD9I4S4H1111"

ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "Services"
StrCmp $0 "" 0 +2
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "Services" "false"
StrCmp $0 "true" 0 +4
ExecWait `"$EXEDIR\${APPDIR}\SyncoveryVSS.exe" /INSTALL /SILENT`
ExecWait `"$SYSDIR\net.exe" start SyncoveryVSSService`
ExecWait `"$SYSDIR\net.exe" start Syncovery_RemoteService`

FunctionEnd

Function Close
ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "Services"
StrCmp $0 "true" 0 +4
ExecWait `"$SYSDIR\net.exe" stop SyncoveryVSSService`
ExecWait `"$EXEDIR\${APPDIR}\SyncoveryRemoteService.exe" /uninstall /silent`
ExecWait `"$EXEDIR\${APPDIR}\SyncoveryVSS" /uninstall /silent`

DeleteINISec "$EXEDIR\Data\${APP}\${APP}.ini" "Registration"
DeleteINIStr "$EXEDIR\Data\${APP}\${APP}.ini" "Main" "LogFolder"
DeleteINIStr "$EXEDIR\Data\${APP}\${APP}.ini" "Main" "DatabasePath"

FunctionEnd

; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call CheckStart

	Call BackupLocalKeys

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close

	Call RestoreLocalKeys

FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
ReadINIStr $1 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AdditionalParameters"
StrCmp $1 "" 0 +2
WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "AdditionalParameters" ""
SetOutPath "$EXEDIR\${APPDIR}"
${GetParameters} $0
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}" /INI="$EXEDIR\Data\${APP}\${APP}.ini" $0 $1`
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd

; **************************************************************************
; ==== Actions on Registry Keys =====
; **************************************************************************
Function BackupLocalKeys
	${registry::BackupKey} "${REGKEY1}"
	${registry::BackupKey} "${REGKEY2}"
	${registry::BackupKey} "${REGKEY3}"
FunctionEnd

Function RestoreLocalKeys
	${registry::RestoreBackupKey} "${REGKEY1}"
	${registry::RestoreBackupKey} "${REGKEY2}"
	${registry::RestoreBackupKey} "${REGKEY3}"
${registry::Unload}
FunctionEnd

