/*
http://www.syncovery.com/release/SyncoverySetup.exe
http://www.syncovery.com/release/SyncoverySetupDE.exe
http://www.syncovery.com/release/SyncoverySetupFR.exe
*/
!define RELEASURL	"http://www.syncovery.com/release"
!define APPSIZE	"56300" # kB
!define DLVER	"6.x"
!define APPVER 	"0.0.0.0"
!define APPNAME "Syncovery"
!define APP 	"Syncovery"
!define DLNAME	"Syncovery"
!define APPLANG	"En-De-Fr_Online"
!define FOLDER	"SyncoveryPortable"
!define MULTILANG ; Delete if not MultiLang
!define FINISHRUN ; Delete if not Finish pages
!define SOURCES ; Delete if no Sources
; !define DESCRIPTION	"Your sync and back-up solution" ; Delete if no AppInfo

SetCompressor /SOLID lzma
SetCompressorDictSize 32

!include "..\_Include\Installer.nsh"

!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "German"

Var LNG ; Delete if no MultiLang

Section "${APPNAME} Portable" main

SectionIn RO
; --- Delete if no MultiLang
StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
StrCpy $LNG ""
StrCmp $LANGUAGE ${LANG_FRENCH} 0 +2
StrCpy $LNG "FR"
StrCmp $LANGUAGE ${LANG_GERMAN} 0 +2
StrCpy $LNG "DE"

	RMDir "/r" "$TEMP\${APP}PortableTemp"
	CreateDirectory "$TEMP\${APP}PortableTemp"
DetailPrint "Installing ${APPNAME} Portable"

; Download
	Dialer::GetConnectedState
	Pop $0
StrCmp $0 "online" +3
	MessageBox MB_USERICON "You are $0: you can't download Setup to extract files!"
	Abort
	inetc::get "${RELEASURL}/${APP}Setup$LNG.exe" "$TEMP\${APP}PortableTemp\${APP}Setup$LNG.exe"
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_USERICON "Download of ${APP}Setup$LNG.exe: $0"
	Abort

	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"
; InnoUnp
	File "/oname=$TEMP\${APP}PortableTemp\innounp.exe" "..\_Include\InnoUnp\innounp.exe"
DetailPrint "Installing ${APPNAME} Portable"
	nsExec::Exec `"$TEMP\${APP}PortableTemp\innounp.exe" -x -d"$TEMP\${APP}PortableTemp\${APP}Setup$LNG" "$TEMP\${APP}PortableTemp\${APP}Setup$LNG.exe"`
; CopyFiles
	SetOutPath "$INSTDIR\App\${APP}"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup$LNG\{app}\*.*" "$INSTDIR\App\${APP}"

!ifdef DESCRIPTION
Call AppInfo
!endif
!ifdef SOURCES
Call Sources
	SetOutPath "$INSTDIR\Other\_Include\InnoUnp"
	File "..\_Include\InnoUnp\innounp.exe"
!endif
!ifdef SOURCES & DESCRIPTION
Call SourceInfo
!endif


SectionEnd

Function .onGUIEnd
	RMDir "/r" "$TEMP\${APP}PortableTemp"
FunctionEnd

; --- Delete if no MultiLang
Function MultiLang
Push ""
Push ${LANG_ENGLISH}
Push English
Push ${LANG_FRENCH}
Push French
Push ${LANG_GERMAN}
Push German
Push A
LangDLL::LangDialog "${APPNAME} Portable Language" "Please select application language."
Pop $LANGUAGE
StrCmp $LANGUAGE "cancel" 0 +2
Abort
FunctionEnd
