/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.CreeperMinion;
import thehippomaster.MutantCreatures.MCHandler;
import thehippomaster.MutantCreatures.MutantCreatures;
import thehippomaster.MutantCreatures.ai.MCAIAttackOnCollide;
import thehippomaster.MutantCreatures.ai.MCAISpiderPigJump;
import thehippomaster.MutantCreatures.packet.PacketSpiderPigJump;

public class SpiderPig
extends EntityCreature
implements IAnimals,
IEntityOwnable {
    public int lastJumpTick = 0;
    public int chargingTick = 0;
    public int exhaustAmount = 0;
    public boolean prevPlayerJumping = false;
    public boolean chargeExhausted = false;
    public MCAISpiderPigJump aiJump;
    public ArrayList<BlockCoord> webList;
    public MCSGTargetSelector mobSelector;

    public SpiderPig(World world) {
        super(world);
        this.field_70158_ak = true;
        this.webList = new ArrayList();
        this.mobSelector = new MCSGTargetSelector(this);
        this.func_70105_a(1.4f, 1.2f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MCAIAttackOnCollide(this, EntityPlayer.class, 1.1f, false).setMaxAttackTick(15));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new MCAIAttackOnCollide(this, 1.1f, true).setMaxAttackTick(15));
        this.aiJump = new MCAISpiderPigJump(this, 8.0f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiJump);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, CreeperMinion.class, 0, true, false, (IEntitySelector)this.mobSelector));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPig.class, 0, true, false, (IEntitySelector)this.mobSelector));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySpider.class, 0, true, false, (IEntitySelector)this.mobSelector));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)"");
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void setOwner(String name) {
        this.field_70180_af.func_75692_b(18, (Object)name);
    }

    public void setOwner(EntityPlayer player) {
        this.setOwner(player.func_70005_c_());
    }

    public String func_152113_b() {
        return this.field_70180_af.func_75681_e(18);
    }

    public String getOwnerName() {
        return this.func_152113_b();
    }

    public EntityPlayer getOwner() {
        return this.field_70170_p.func_72924_a(this.getOwnerName());
    }

    public boolean getTamed() {
        return !this.getOwnerName().equals("");
    }

    protected boolean func_70692_ba() {
        return !this.getTamed();
    }

    public Team func_96124_cp() {
        EntityPlayer entitylivingbase;
        if (this.getTamed() && (entitylivingbase = this.getOwner()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_142014_c(EntityLivingBase living) {
        if (this.getTamed()) {
            EntityPlayer owner = this.getOwner();
            if (living == owner) {
                return true;
            }
            if (owner != null) {
                return owner.func_142014_c(living);
            }
        }
        return super.func_142014_c(living);
    }

    public void setBesideClimbableBlock(boolean flag) {
        byte b0 = this.field_70180_af.func_75683_a(19);
        b0 = flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(19, (Object)b0);
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(19) & 1) != 0;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_76456_a() == Potion.field_76436_u.field_76415_H ? false : super.func_70687_e(effect);
    }

    protected void func_70069_a(float f) {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.field_70153_n != null) {
            this.field_70138_W = 1.0f;
            this.field_70177_z = this.field_70759_as = this.field_70153_n.field_70177_z;
            this.field_70126_B = this.field_70759_as;
            this.field_70127_C = this.field_70125_A = this.field_70153_n.field_70125_A * 0.4f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            while (this.field_70761_aq > this.field_70759_as + 180.0f) {
                this.field_70761_aq -= 360.0f;
            }
            while (this.field_70761_aq < this.field_70759_as - 180.0f) {
                this.field_70761_aq += 360.0f;
            }
            this.field_70761_aq += (this.field_70759_as - this.field_70761_aq) * 0.3f;
            EntityLivingBase rider = (EntityLivingBase)this.field_70153_n;
            EntityPlayer player = null;
            if (rider instanceof EntityPlayer) {
                player = (EntityPlayer)rider;
            }
            float speed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
            if (!this.field_70170_p.field_72995_K) {
                if (!this.func_70661_as().func_75500_f()) {
                    this.func_70661_as().func_75499_g();
                }
                forward = rider.field_70701_bs * 0.8f;
                strafe = rider.field_70702_br * 0.6f;
                this.func_70659_e(speed);
                super.func_70612_e(strafe, forward);
            } else {
                if (player != null) {
                    boolean jumping = MutantCreatures.proxy.updateSpiderPigRider(this, player);
                    if (!jumping && this.prevPlayerJumping) {
                        MutantCreatures.wrapper.sendToServer((IMessage)new PacketSpiderPigJump(this));
                    }
                    this.prevPlayerJumping = jumping;
                }
                this.field_70722_aY = this.field_70721_aZ;
                double d0 = this.field_70165_t - this.field_70169_q;
                double d1 = this.field_70161_v - this.field_70166_s;
                float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_70754_ba += this.field_70721_aZ;
            }
            return;
        }
        this.field_70138_W = 0.5f;
        super.func_70612_e(strafe, forward);
    }

    protected void updateWebList(boolean onlyCheckSize) {
        if (!onlyCheckSize) {
            for (int i = 0; i < this.webList.size(); ++i) {
                BlockCoord coord = this.webList.get(i);
                Block block = this.field_70170_p.func_147439_a(coord.x, coord.y, coord.z);
                if (block.func_149688_o() != Material.field_151569_G) {
                    this.webList.remove(i);
                    --i;
                    continue;
                }
                --coord.timeLeft;
            }
            if (!this.webList.isEmpty()) {
                BlockCoord first = this.webList.get(0);
                if (first.timeLeft < 0) {
                    this.webList.remove(0);
                    this.field_70170_p.func_72926_e(2001, first.x, first.y, first.z, Block.func_149682_b((Block)Blocks.field_150321_G));
                    this.field_70170_p.func_147465_d(first.x, first.y, first.z, Blocks.field_150350_a, 0, 3);
                }
            }
        }
        while (this.webList.size() > 12) {
            BlockCoord coord = this.webList.remove(0);
            this.field_70170_p.func_72926_e(2001, coord.x, coord.y, coord.z, Block.func_149682_b((Block)Blocks.field_150321_G));
            this.field_70170_p.func_147465_d(coord.x, coord.y, coord.z, Blocks.field_150350_a, 0, 3);
        }
    }

    protected void updateChargeState() {
        if (this.exhaustAmount >= 120) {
            this.chargeExhausted = true;
        }
        if (this.exhaustAmount <= 0) {
            this.chargeExhausted = false;
        }
        this.exhaustAmount = Math.max(0, this.exhaustAmount - 1);
        if (this.chargingTick > 0) {
            ArrayList<Entity> list = MutantCreatures.getCollidingEntities((Entity)this, this.field_70170_p, this.field_70121_D);
            float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            for (Entity entity : list) {
                if (entity == this.field_70153_n) continue;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage * 0.5f);
            }
        }
        this.chargingTick = Math.max(0, this.chargingTick - 1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            this.lastJumpTick = Math.max(0, this.lastJumpTick - 1);
            if (this.aiJump.jumpTick > 10 && this.field_70122_E) {
                this.aiJump.running = false;
            }
            this.updateWebList(false);
            this.updateChargeState();
            if (this.getTamed() && this.field_70173_aa % 600 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        super.func_70652_k(entity);
        this.aiJump.running = false;
        boolean dealDamage = true;
        if (this.field_70146_Z.nextInt(2) == 0) {
            int z;
            double dx = entity.field_70165_t - entity.field_70169_q;
            double dz = entity.field_70161_v - entity.field_70166_s;
            int x = (int)(entity.field_70165_t + dx * 0.5);
            int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            Material material = this.field_70170_p.func_147439_a(x, y, z = (int)(entity.field_70161_v + dz * 0.5)).func_149688_o();
            if (!material.func_76220_a() && !material.func_76224_d() && material != Material.field_151569_G) {
                this.field_70170_p.func_147465_d(x, y, z, Blocks.field_150321_G, 0, 3);
                this.webList.add(new BlockCoord(x, y, z));
                this.updateWebList(true);
                this.field_70181_x = Math.max(0.25, this.field_70181_x);
                this.field_70143_R = 0.0f;
            } else {
                dealDamage = true;
            }
        }
        if (dealDamage) {
            boolean spiderType;
            float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            boolean bl = spiderType = entity instanceof EntitySpider || entity instanceof SpiderPig;
            if (((Boolean)ReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String[])MutantCreatures.fIsInWeb)).booleanValue() && !spiderType) {
                damage += 4.0f;
            }
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        }
        return false;
    }

    public void func_70074_a(EntityLivingBase living) {
        if (!this.field_70170_p.field_72995_K) {
            boolean killedPrey;
            if (living instanceof CreeperMinion) {
                CreeperMinion minion = (CreeperMinion)living;
                if (minion.getTamed() && this.func_110143_aJ() <= 8.0f) {
                    this.setOwner(minion.getOwner());
                }
                minion.func_70106_y();
            }
            boolean bl = killedPrey = living instanceof EntityPig || living instanceof EntitySpider;
            if (killedPrey) {
                living.func_70106_y();
                SpiderPig pig = new SpiderPig(this.field_70170_p);
                pig.func_70080_a(living.field_70165_t, living.field_70163_u, living.field_70161_v, living.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)pig);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float dmg) {
        if (source.func_76346_g() != null && source.func_76346_g() == this.field_70153_n) {
            return false;
        }
        return super.func_70097_a(source, dmg);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K && !this.webList.isEmpty()) {
            for (BlockCoord coord : this.webList) {
                Block block = this.field_70170_p.func_147439_a(coord.x, coord.y, coord.z);
                if (block.func_149688_o() != Material.field_151569_G) continue;
                this.field_70170_p.func_72926_e(2001, coord.x, coord.y, coord.z, Block.func_149682_b((Block)Blocks.field_150321_G));
                this.field_70170_p.func_147465_d(coord.x, coord.y, coord.z, Blocks.field_150350_a, 0, 3);
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        boolean correctPlayer = player.func_70005_c_().equalsIgnoreCase(this.getOwnerName());
        if (!this.field_70170_p.field_72995_K && correctPlayer) {
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (stack != null) {
                boolean fullHealth;
                Item item = stack.func_77973_b();
                boolean bl = fullHealth = this.func_110143_aJ() >= this.func_110138_aP();
                if (item == Items.field_151147_al || item == Items.field_151070_bp) {
                    if (!fullHealth) {
                        this.func_70691_i(4 + this.field_70146_Z.nextInt(5));
                        if (!player.field_71075_bZ.field_75098_d) {
                            --stack.field_77994_a;
                        }
                        MCHandler.spawnParticlesAtEntity(0, (Entity)this, 1);
                    }
                    return false;
                }
            }
            if (this.field_70153_n == null) {
                player.field_70177_z = this.field_70759_as;
                player.func_70078_a((Entity)this);
            }
        }
        return super.func_70085_c(player);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && MutantCreatures.getRandomSpawnChance();
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        tagcompound.func_74778_a("owner", this.getOwnerName());
        if (!this.webList.isEmpty()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("length", (short)this.webList.size());
            for (int i = 0; i < this.webList.size(); ++i) {
                BlockCoord coord = this.webList.get(i);
                int[] coords = new int[]{coord.x, coord.y, coord.z};
                tag.func_74783_a("coord" + i, coords);
                tag.func_74768_a("time" + i, coord.timeLeft);
            }
            tagcompound.func_74782_a("webList", (NBTBase)tag);
        }
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        this.setOwner(tagcompound.func_74779_i("owner"));
        if (tagcompound.func_74764_b("webList")) {
            NBTTagCompound tag = (NBTTagCompound)tagcompound.func_74781_a("webList");
            int length = tag.func_74765_d("length");
            for (int i = 0; i < length; ++i) {
                int[] coords = tag.func_74759_k("coord" + i);
                int time = tag.func_74762_e("time" + i);
                BlockCoord coord = new BlockCoord(coords, time);
                this.webList.add(coord);
            }
        }
    }

    protected String func_70639_aQ() {
        return "mob.pig.say";
    }

    protected String func_70621_aR() {
        return "mob.pig.death";
    }

    protected String func_70673_aS() {
        return "mob.zombiepig.zpighurt";
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    public static class MCSGTargetSelector
    implements IEntitySelector {
        private SpiderPig spiderpig;

        public MCSGTargetSelector(SpiderPig pig) {
            this.spiderpig = pig;
        }

        public boolean func_82704_a(Entity entity) {
            if (this.spiderpig.getTamed()) {
                return false;
            }
            if (entity instanceof CreeperMinion) {
                return ((CreeperMinion)entity).getTamed();
            }
            return true;
        }
    }

    public static class BlockCoord {
        public int x;
        public int y;
        public int z;
        public int timeLeft;

        public BlockCoord(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.timeLeft = 1200;
        }

        public BlockCoord(int[] coords, int time) {
            this.x = coords[0];
            this.y = coords[1];
            this.z = coords[2];
            this.timeLeft = time;
        }
    }
}

