//////////////////////////////////////////////////////////////////////////
// Mapper169        for YuXing                                          //
//////////////////////////////////////////////////////////////////////////

void	Mapper169::Reset()
{
	DWORD	crc = nes->rom->GetPROM_CRC();
	if(crc == 0x2B1B969E	//YX_V8.2-D
	|| crc == 0xA70FD0F3)	//YX_V8.3-D
	{
		YX_type = 0;	//D
	}
	if(crc == 0x6085FEE8	//YX_V9.0-98
	|| crc == 0x2A1E4D89	//YX_V9.2-98
	|| crc == 0x5C6CE13E)	//YX_V9.2-F
	{
		YX_type = 1;	//98 & F
	}

	nes->ppu->SetExtLatchMode( TRUE );
	reg[0] = 0xFF;	//$5002
	reg[1] = 0x00;	//$4800
	reg[2] = 0x00;	//$5500
	reg[3] = 0x00;	//$5501
	reg[4] = 0x00;	//PPU_Latch
	reg[5] = 0x00;	//$8000
	reg[6] = 0x00;
	reg[7] = 0x01;
	cmd_4800_6 = 0x00;
	cmd_4800_7 = 0x00;
	cmd_4800_8 = 0x00;
	cmd_5500_3 = 0x00;
	cmd_5500_8 = 0x00;
	cmd_5501_8 = 0x00;
	key_map_row = 0x00;
	MMC3_mode = 0x00;

	SetPROM_32K_Bank( 0 );
	SetYCRAM_8K_Bank( 0 );
/*
//--for test disk program-----------------------------------------
	int fs;
	fs = 0x000000;
	fs = 0x100000;
	memcpy( YWRAM, PROM+fs, PROM_8K_SIZE*0x2000-fs);
	memcpy( YWRAM+0xFC000, PROM+(PROM_16K_SIZE-1)*0x4000, 0x4000);
	SetYWRAM_32K_Bank( 0, 1, 0x7e, 0x7f );
//----------------------------------------------------------------
*/
}

BYTE	Mapper169::ReadLow( WORD addr )
{
//	DEBUGOUT( "ReadL  A=%04X D=%02X L=%3d CYC=%d\n", addr&0xFFFF, Mapper::ReadLow( addr ), nes->GetScanline(), nes->cpu->GetTotalCycles() );

	int key_map[14][8] = {	//YuXing_Keyboard data by tpu (fix by temryu)
		{DIK_ESCAPE, DIK_F9,         DIK_7,      DIK_R,       DIK_A,      0x00,          0x00,         DIK_LSHIFT},
		{0x00,       DIK_NUMPADENTER,0x00,       DIK_MULTIPLY,DIK_DIVIDE, DIK_UP,        DIK_BACKSPACE,DIK_F12   },
		{0x00,       0x00,           0x00,       DIK_ADD,     DIK_NUMLOCK,DIK_LEFT,      DIK_DOWN,     DIK_RIGHT },
		{0x00,       DIK_NUMPAD7,    DIK_NUMPAD8,DIK_SUBTRACT,DIK_NUMPAD9,DIK_F11,       DIK_END,      DIK_PGDN  },
		{DIK_F8,     DIK_6,          DIK_E,      DIK_RBRACKET,DIK_L,      DIK_Z,         DIK_N,        DIK_SPACE },
		{DIK_F7,     DIK_5,          DIK_W,      DIK_LBRACKET,DIK_K,      DIK_DELETE,    DIK_B,        DIK_SLASH },
		{DIK_F6,     DIK_4,          DIK_Q,      DIK_P,       DIK_J,      DIK_BACKSLASH, DIK_V,        DIK_PERIOD},
		{DIK_F5,     DIK_3,          DIK_EQUALS, DIK_O,       DIK_H,      DIK_APOSTROPHE,DIK_C,        DIK_COMMA },
		{DIK_F4,     DIK_2,          DIK_MINUS,  DIK_I,       DIK_G,      DIK_SEMICOLON, DIK_X,        DIK_M     },
		{DIK_F3,     DIK_1,          DIK_0,      DIK_U,       DIK_F,      DIK_CAPITAL,   DIK_LWIN,     0x00      },
		{DIK_F2,     DIK_GRAVE,      DIK_9,      DIK_Y,       DIK_D,      DIK_LCONTROL,  DIK_LMENU,    DIK_SCROLL},
		{DIK_F1,     DIK_RETURN,     DIK_8,      DIK_T,       DIK_S,      0x00,          DIK_RWIN,     DIK_APPS  },
		{DIK_DECIMAL,DIK_F10,        DIK_NUMPAD4,DIK_NUMPAD6, DIK_NUMPAD5,DIK_INSERT,    DIK_HOME,     DIK_PGUP  },
		{0x00,       DIK_NUMPAD0,    DIK_NUMPAD1,DIK_NUMPAD3, DIK_NUMPAD2,DIK_SYSRQ,     DIK_TAB,      DIK_PAUSE },
	};
	if( YX_type == 0 )	//for D (without new keys)
	{
		key_map[9][6] = 0x00;
		key_map[11][6] = 0x00;
		key_map[11][7] = 0x00;
	}

	switch( addr ) {
		case	0x4207:	//YuXing_Keyboard code by tpu
			int r, i, data;
			data = 0;
			for(r=0; r<14; r++){
				if(key_map_row&(1<<r)){
					for(i=0; i<8; i++){
						if(key_map[r][i])
							if(DirectInput.m_Sw[key_map[r][i]]) data |= 1<<i;
						//special cases
						if((r== 0)&&(i==7))
							if(DirectInput.m_Sw[DIK_RSHIFT   ]) data |= 1<<i;
						if((r==10)&&(i==5))
							if(DirectInput.m_Sw[DIK_RCONTROL ]) data |= 1<<i;
						if((r==10)&&(i==6))
							if(DirectInput.m_Sw[DIK_RMENU    ]) data |= 1<<i;
					}
				}
			}
			return data;
			break;

		case	0x4304:
			return reg[7];
			break;
		case	0x5002:
			return reg[0];
			break;
	}

	if(addr>=0x6000) return CPU_MEM_BANK[addr>>13][addr&0x1FFF];
	return Mapper::ReadLow( addr );
}

void	Mapper169::WriteLow( WORD addr, BYTE data )
{
	if(addr>=0x6000) CPU_MEM_BANK[addr>>13][addr&0x1FFF]=data;

//	if(addr>0x4207) DEBUGOUT( "WriteL A=%04X D=%02X L=%3d CYC=%d\n", addr&0xFFFF, data&0xFF, nes->GetScanline(), nes->cpu->GetTotalCycles() );
	switch( addr ) {
		case	0x4201:
			//
			break;

		case	0x4202:	//YuXing_Keyboard
			key_map_row &= 0xff00;
			key_map_row |= data;
			break;
		case	0x4203:	//YuXing_Keyboard
		case	0x4303:
			key_map_row &= 0x00ff;
			key_map_row |= (data & 0x3f)<<8;
			break;

		case	0x4800:
			reg[1] = data;
			cmd_4800_6 = reg[1]&0x20;	//ȡ6λRAMأ1򿪣0ر
			cmd_4800_7 = reg[1]&0x40;	//ȡ7λ
			cmd_4800_8 = reg[1]&0x80;	//ȡ8λڿPPU_ExtLatch

			SetBank_CPU();
			break;
		case	0x5500:
			reg[2] = data;
			cmd_5500_3 = reg[2]&0x04;	//ȡ3λRAMй
			cmd_5500_8 = reg[2]&0x80;	//ȡ8λڿPPU_Latch

			SetBank_CPU();
			break;
		case	0x5501:
			reg[3] = data;
			cmd_5501_8 = reg[3]&0x80;	//ȡ8λMMC3ģʽá滭塱ѡ(???)

			SetYCRAM_8K_Bank( reg[3] & 0x7F );
			if(cmd_5501_8){
				MMC3_mode = 1;
				SetYWRAM_16K_Bank( 6, 0x1F );
			}else{
				MMC3_mode = 0;
			}
			break;
	}
}

void	Mapper169::Write( WORD addr, BYTE data )
{
//	DEBUGOUT( "WriteH A=%04X D=%02X L=%3d CYC=%d\n", addr&0xFFFF, data&0xFF, nes->GetScanline(), nes->cpu->GetTotalCycles() );

	if(cmd_5500_3 && MMC3_mode){
		MMC3_WriteH( addr, data );
		return;
	}

	if(cmd_5500_3){
		if(cmd_4800_6){
			reg[5] = data&0x3F;
		}else{
			WriteCPU_PRAM( addr, data );
		}
	}

}

void	Mapper169::SetBank_CPU()
{
	if(cmd_5500_3 && MMC3_mode) return;

	if(cmd_5500_3){
		SetYWRAM_16K_Bank( 4, reg[5] );
		SetYWRAM_16K_Bank( 6, 0x3F );
	}else{
		SetPROM_32K_Bank(reg[1]&0x1F);
	}

	SetPROM_Bank( 3, &YSRAM[0x2000*(reg[2]&0x3)], BANKTYPE_RAM );
	CPU_MEM_PAGE[3]=reg[2]&0x3;
}

void	Mapper169::WriteCPU_PRAM( WORD addr, BYTE data )
{
	if(addr<0xC000){
		YWRAM[(addr-0x8000)+(reg[5]*0x4000)] = data;
	}else{
		YWRAM[addr+0xF0000] = data;	//HOME BANK
	}
}

void	Mapper169::PPU_Latch( WORD addr )
{
	if((addr&0xF000)==0x2000){
		reg[4]=(addr>>8)&0x03;
		if(cmd_4800_8 && cmd_5500_8){
			SetYCRAM_8K_Bank((reg[4]<<2)+(reg[3]&0x03));
			SetYCRAM_4K_Bank(0,reg[3]<<1);
		}
	}

//	if(DirectInput.m_Sw[DIK_PAUSE]) nes->Dump_YWRAM();

}
void	Mapper169::PPU_ExtLatchX( INT x )
{
	a3 = (x&1)<<3;
}
void	Mapper169::PPU_ExtLatch( WORD ntbladr, BYTE& chr_l, BYTE& chr_h, BYTE& attr )
{
	INT loopy_v = nes->ppu->GetPPUADDR();
	INT loopy_y = nes->ppu->GetTILEY();
	INT	tileofs = (PPUREG[0]&PPU_BGTBL_BIT)<<8;
	INT	attradr = 0x23C0+(loopy_v&0x0C00)+((loopy_v&0x0380)>>4);
	INT	attrsft = (ntbladr&0x0040)>>4;
	LPBYTE	pNTBL = PPU_MEM_BANK[ntbladr>>10];
	INT	ntbl_x  = ntbladr&0x001F;
	INT	tileadr;
	attradr &= 0x3FF;
	attr = ((pNTBL[attradr+(ntbl_x>>2)]>>((ntbl_x&2)+attrsft))&3)<<2;
	tileadr = tileofs+pNTBL[ntbladr&0x03FF]*0x10+loopy_y;
	if(cmd_4800_8 && !cmd_5500_8){
		if(reg[4]&0x02)	tileadr |=  0x1000;
		else			tileadr &= ~0x1000;
		tileadr = (tileadr&0xfff7)|a3;
		chr_l = chr_h = PPU_MEM_BANK[tileadr>>10][ tileadr&0x03FF   ];
	}else{
		chr_l = PPU_MEM_BANK[tileadr>>10][ tileadr&0x03FF   ];
		chr_h = PPU_MEM_BANK[tileadr>>10][(tileadr&0x03FF)+8];
	}
}
BYTE	Mapper169::PPU_ExtLatchSP()	//ɫ⣬δȫ
{
	if(cmd_4800_8 && !cmd_5500_8)
		return 2;	//ʱ˴ԭδ֪пVirtuaNES⡣
	return 0;
}

void	Mapper169::MMC3_WriteH( WORD addr, BYTE data )
{
	switch(addr) {
		case	0x8000:
			MMC3_reg = data;
			MMC3_SetBank_CPU();
			MMC3_SetBank_PPU();
			break;
		case	0x8001:
			switch(MMC3_reg&0x07) {
				case	0x02:
					MMC3_chr4 = data;
					MMC3_SetBank_PPU();
					break;
				case	0x03:
					MMC3_chr5 = data;
					MMC3_SetBank_PPU();
					break;
				case	0x04:
					MMC3_chr6 = data;
					MMC3_SetBank_PPU();
					break;
				case	0x05:
					MMC3_chr7 = data;
					MMC3_SetBank_PPU();
					break;
				case	0x06:
					MMC3_prg0 = data;
					MMC3_SetBank_CPU();
					break;
				case	0x07:
					MMC3_prg1 = data;
					MMC3_SetBank_CPU();
					break;
			}
			break;
	}
}
void	Mapper169::MMC3_SetBank_CPU()
{
	SetYWRAM_32K_Bank( MMC3_prg0, MMC3_prg1, 0x3E, 0x3F );
}
void	Mapper169::MMC3_SetBank_PPU()
{
	SetYCRAM_1K_Bank( 4, MMC3_chr4&0x0F );
	SetYCRAM_1K_Bank( 5, MMC3_chr5&0x0F );
	SetYCRAM_1K_Bank( 6, MMC3_chr6&0x0F );
	SetYCRAM_1K_Bank( 7, MMC3_chr7&0x0F );
}
