//////////////////////////////////////////////////////////////////////////
// Mapper169                                                            //
//////////////////////////////////////////////////////////////////////////

#include "DirectInput.h"
class	Mapper169 : public Mapper
{
public:
	Mapper169( NES* parent ) : Mapper(parent) {}

	void	Reset();
	BYTE	ReadLow ( WORD addr );
	void	WriteLow( WORD addr, BYTE data );
	void	Write( WORD addr, BYTE data );
	void	PPU_Latch( WORD addr );
	void	PPU_ExtLatchX( INT x );
	void	PPU_ExtLatch( WORD ntbladr, BYTE& chr_l, BYTE& chr_h, BYTE& attr );
	BYTE	PPU_ExtLatchSP();

protected:
	BYTE	YX_type, reg[8];

	BYTE	a3;
	INT		key_map_row;
	BYTE	cmd_4800_6,cmd_4800_7,cmd_4800_8;
	BYTE	cmd_5500_3,cmd_5500_8;
	BYTE	cmd_5501_8;

	BYTE	MMC3_mode,MMC3_reg,MMC3_prg0,MMC3_prg1;
	BYTE	MMC3_chr4,MMC3_chr5,MMC3_chr6,MMC3_chr7;

private:
	void	SetBank_CPU();
	void	WriteCPU_PRAM( WORD addr, BYTE data );

	void	MMC3_WriteH( WORD addr, BYTE data );
	void	MMC3_SetBank_CPU();
	void	MMC3_SetBank_PPU();
};
